/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.controller.ActionProcessor;
import org.seasar.cubby.controller.ActionResultWrapper;
import org.seasar.cubby.controller.ThreadContext;
import org.seasar.cubby.filter.CubbyHttpServletRequestWrapper;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;

public class CubbyFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(CubbyFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        CubbyHttpServletRequestWrapper request = new CubbyHttpServletRequestWrapper((HttpServletRequest)req);
        HttpServletResponse response = (HttpServletResponse)res;
        ThreadContext.setRequest((HttpServletRequest)request);
        try {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            ActionProcessor processor = (ActionProcessor)container.getComponent(ActionProcessor.class);
            ActionResultWrapper actionResultWrapper = processor.process((HttpServletRequest)request, response);
            if (actionResultWrapper != null) {
                actionResultWrapper.execute((HttpServletRequest)request, response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            logger.log((Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            ThreadContext.remove();
        }
    }
}

