/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.controller.FormWrapperFactory;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.ConverterFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class FormWrapperFactoryImpl
implements FormWrapperFactory {
    private ConverterFactory converterFactory;
    private ConversionHelper conversionHelper;

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public void setConversionHelper(ConversionHelper conversionHelper) {
        this.conversionHelper = conversionHelper;
    }

    public FormWrapper create(Object form) {
        FormWrapperImpl formObject = new FormWrapperImpl(form);
        return formObject;
    }

    private class FormWrapperImpl
    implements FormWrapper {
        private final Object form;

        private FormWrapperImpl(Object form) {
            this.form = form;
        }

        public String[] getValues(String name) {
            if (this.form == null) {
                return null;
            }
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.form.getClass());
            if (!beanDesc.hasPropertyDesc(name)) {
                return null;
            }
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(name);
            Object value = propertyDesc.getValue(this.form);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                String[] array = (String[])Array.newInstance(String.class, length);
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(value, i);
                    String converted = this.convert(element);
                    Array.set(array, i, converted);
                }
                return array;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                String[] array = (String[])Array.newInstance(String.class, collection.size());
                int i = 0;
                for (Object element : collection) {
                    String converted = this.convert(element);
                    Array.set(array, i++, converted);
                }
                return array;
            }
            String[] array = (String[])Array.newInstance(String.class, 1);
            String converted = this.convert(value);
            Array.set(array, 0, converted);
            return array;
        }

        private String convert(Object value) {
            if (value == null) {
                return null;
            }
            Converter converter = FormWrapperFactoryImpl.this.converterFactory.getConverter(null, value.getClass());
            if (converter == null) {
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
            return converter.convertToString(value, FormWrapperFactoryImpl.this.conversionHelper);
        }
    }
}

