/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.controller.ActionProcessor;
import org.seasar.cubby.controller.ActionResultWrapper;
import org.seasar.cubby.controller.RequestParser;
import org.seasar.cubby.controller.RequestParserSelector;
import org.seasar.cubby.controller.RoutingsDispatcher;
import org.seasar.cubby.controller.impl.ActionResultWrapperImpl;
import org.seasar.cubby.exception.ActionRuntimeException;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionProcessorImpl
implements ActionProcessor {
    private static final Logger logger = Logger.getLogger(ActionProcessorImpl.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private RoutingsDispatcher routingsDispatcher;
    private RequestParserSelector requestParserSelector;

    public void setRoutingsDispatcher(RoutingsDispatcher routingsDispatcher) {
        this.routingsDispatcher = routingsDispatcher;
    }

    public void setRequestParserSelector(RequestParserSelector requestParserSelector) {
        this.requestParserSelector = requestParserSelector;
    }

    @Override
    public ActionResultWrapper process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map routings = (Map)CubbyUtils.getAttribute(request, "org.seasar.cubby.routings");
        if (routings == null) {
            return null;
        }
        request.removeAttribute("org.seasar.cubby.routings");
        Map<String, Object[]> parameterMap = this.parseRequest(request);
        request.setAttribute("org.seasar.cubby.params", parameterMap);
        Routing routing = this.routingsDispatcher.dispatch(routings, parameterMap);
        if (routing == null) {
            return null;
        }
        Class<? extends Action> actionClass = routing.getActionClass();
        Method method = routing.getMethod();
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0004", new Object[]{request.getRequestURI()});
            logger.log("DCUB0005", new Object[]{method});
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Action action = (Action)container.getComponent(actionClass);
        request.setAttribute("action", (Object)action);
        ActionResult actionResult = this.invoke(action, method);
        if (actionResult == null) {
            throw new ActionRuntimeException("ECUB0101", new Object[]{method});
        }
        ActionResultWrapperImpl actionResultWrapper = new ActionResultWrapperImpl(actionResult, action, actionClass, method);
        return actionResultWrapper;
    }

    private ActionResult invoke(Action action, Method method) throws Exception {
        try {
            ActionResult result = (ActionResult)method.invoke((Object)action, EMPTY_ARGS);
            return result;
        }
        catch (InvocationTargetException ex) {
            logger.log((Throwable)ex);
            Throwable target = ex.getTargetException();
            if (target instanceof Error) {
                throw (Error)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw (Exception)target;
        }
    }

    private Map<String, Object[]> parseRequest(HttpServletRequest request) {
        RequestParser requestParser = this.requestParserSelector.select(request);
        if (requestParser == null) {
            throw new NullPointerException("requestParser");
        }
        if (logger.isDebugEnabled()) {
            logger.log("DCUB0016", new Object[]{requestParser});
        }
        Map<String, Object[]> parameterMap = requestParser.getParameterMap(request);
        return parameterMap;
    }
}

