/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.admin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.admin.servlet.RoutingSection;
import org.seasar.framework.util.InputStreamUtil;

public class CubbyAdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String css;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.css = this.getResource("cubby-admin.css");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String remoteAddr = request.getRemoteAddr();
        if (!this.isLoopBackAddress(remoteAddr)) {
            return;
        }
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.render(request, response);
    }

    private boolean isLoopBackAddress(String remoteAddr) {
        return remoteAddr.equals("127.0.0.1") || remoteAddr.startsWith("0:0:0:0:0:0:0:1");
    }

    private void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        out.println("<title>Cubby Admin Tool</title>");
        out.println("<style>");
        out.println(this.css);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<div id=\"banner\">");
        out.println("<h1>Cubby Admin Tool</h1>");
        out.println("</div>");
        out.println("<div id=\"main\">");
        RoutingSection routingSection = new RoutingSection(request, response);
        routingSection.print();
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    private String getResource(String resourceName) throws ServletException {
        try {
            return new String(InputStreamUtil.getBytes((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resourceName)), "UTF-8");
        }
        catch (Exception e) {
            throw new ServletException("Can't read resouce file : " + resourceName, (Throwable)e);
        }
    }
}

