/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.util.StringUtil;

public class SendErrorFilter
implements Filter {
    private static final String STATUS_CODE = "statusCode";
    private static final String IGNORE_PATH_PATTERN = "ignorePathPattern";
    private int statusCode = 403;
    private final List<Pattern> ignorePathPatterns = new ArrayList<Pattern>();

    public void init(FilterConfig config) throws ServletException {
        String ignorePathPatternString;
        String statusCodeString = config.getInitParameter(STATUS_CODE);
        if (statusCodeString != null) {
            this.statusCode = Integer.parseInt(statusCodeString);
        }
        if (!StringUtil.isEmpty((String)(ignorePathPatternString = config.getInitParameter(IGNORE_PATH_PATTERN)))) {
            StringTokenizer tokenizer = new StringTokenizer(ignorePathPatternString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Pattern pattern = Pattern.compile(token);
                this.ignorePathPatterns.add(pattern);
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isIgnore(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(this.statusCode);
        }
    }

    private boolean isIgnore(HttpServletRequest request) {
        for (Pattern ignorePattern : this.ignorePathPatterns) {
            String servletPath;
            Matcher matcher = ignorePattern.matcher(servletPath = request.getServletPath());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

