/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.action;

import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.InitializeMethod;
import org.seasar.cubby.action.PostRenderMethod;
import org.seasar.cubby.action.PreRenderMethod;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Action {
    protected ActionErrors errors;
    protected Map<String, Object> flash;

    public ActionErrors getErrors() {
        return this.errors;
    }

    public void setErrors(ActionErrors errors) {
        this.errors = errors;
    }

    public Map<String, Object> getFlash() {
        return this.flash;
    }

    public void setFlash(Map<String, Object> flash) {
        this.flash = flash;
    }

    public void invokeInitializeMethod(Method actionMethod) {
        if (actionMethod.isAnnotationPresent(InitializeMethod.class)) {
            InitializeMethod initializeMethod = actionMethod.getAnnotation(InitializeMethod.class);
            String methodName = initializeMethod.value();
            this.invoke(methodName);
        } else {
            this.initialize();
        }
    }

    protected void initialize() {
    }

    public void invokePreRenderMethod(Method actionMethod) {
        if (actionMethod.isAnnotationPresent(PreRenderMethod.class)) {
            PreRenderMethod preRenderMethod = actionMethod.getAnnotation(PreRenderMethod.class);
            String methodName = preRenderMethod.value();
            this.invoke(methodName);
        } else {
            this.prerender();
        }
    }

    protected void prerender() {
    }

    public void invokePostRenderMethod(Method actionMethod) {
        if (actionMethod.isAnnotationPresent(PostRenderMethod.class)) {
            PostRenderMethod postRenderMethod = actionMethod.getAnnotation(PostRenderMethod.class);
            String methodName = postRenderMethod.value();
            this.invoke(methodName);
        } else {
            this.postrender();
        }
    }

    protected void postrender() {
    }

    protected void invoke(String methodName) {
        Method method = ClassUtil.getMethod(this.getClass(), (String)methodName, null);
        MethodUtil.invoke((Method)method, (Object)this, null);
    }
}

