/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.admin.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.cubby.admin.servlet.LoopingIterator;
import org.seasar.cubby.admin.servlet.Messages;
import org.seasar.cubby.admin.servlet.Section;
import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.routing.Routing;
import org.seasar.cubby.routing.impl.PathResolverImpl;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;

class RoutingSection
implements Section {
    private HttpServletRequest request;
    private PrintWriter out;
    private Locale locale;
    private PathResolver pathResolver;
    private Iterator<String> rowClasses = new LoopingIterator<String>(Arrays.asList("odd", "even"));
    private Messages messages;

    public RoutingSection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.out = response.getWriter();
        this.locale = request.getLocale();
        this.pathResolver = (PathResolverImpl)SingletonS2Container.getComponent(PathResolver.class);
        this.messages = new Messages(this.locale);
    }

    public void print() {
        String path = this.request.getParameter("path");
        this.out.println("<form name=\"pathSerachForm\">");
        this.out.print("<label for=\"path\">");
        this.out.print(this.messages.getString("lbl.path"));
        this.out.print("</label>");
        this.out.print("<input type=\"text\" name=\"path\" size=\"40\" value=\"");
        this.out.print(CubbyUtils.escapeHtml((Object)path));
        this.out.println("\" />");
        this.out.print("<input type=\"submit\" value=\"");
        this.out.print(this.messages.getString("lbl.test"));
        this.out.println("\">");
        this.out.print("<input type=\"button\" value=\"");
        this.out.print(this.messages.getString("lbl.clear"));
        this.out.println("\" onclick=\"pathSerachForm.path.value='';pathSerachForm.submit();\">");
        this.out.println("</form>");
        this.out.println("<table>");
        this.out.println("<thead>");
        this.out.println(RoutingSection.th(this.messages.getString("lbl.no")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.regexp")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.requestMethod")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.actionMethod")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.pathParams")));
        this.out.println(RoutingSection.th(this.messages.getString("lbl.priority")));
        this.out.println("</thead>");
        this.out.println("<tbody>");
        int no = 1;
        for (Routing routing : this.pathResolver.getRoutings()) {
            HashMap<String, String> pathParameters;
            boolean write;
            if (StringUtil.isEmpty((String)path)) {
                write = true;
                pathParameters = null;
            } else {
                Matcher matcher = routing.getPattern().matcher(path);
                if (matcher.matches()) {
                    write = true;
                    pathParameters = new HashMap<String, String>();
                    for (int i = 0; i < matcher.groupCount(); ++i) {
                        String name = (String)routing.getUriParameterNames().get(i);
                        String value = matcher.group(i + 1);
                        pathParameters.put(name, value);
                    }
                } else {
                    write = false;
                    pathParameters = null;
                }
            }
            if (write) {
                this.out.print("<tr class=\"");
                this.out.print(this.rowClasses.next());
                this.out.println("\">");
                this.out.println(RoutingSection.td(no));
                this.out.println(RoutingSection.td(routing.getPattern().pattern()));
                this.out.println(RoutingSection.td(routing.getRequestMethod()));
                this.out.println(RoutingSection.td(routing.getActionClass().getName() + "#" + routing.getMethod().getName()));
                if (pathParameters == null) {
                    this.out.println(RoutingSection.td(routing.getUriParameterNames()));
                } else {
                    this.out.println(RoutingSection.td(pathParameters));
                }
                this.out.println(RoutingSection.td(routing.getPriority()));
                this.out.println("</tr>");
            }
            ++no;
        }
        this.out.println("</tbody>");
        this.out.println("</table>");
    }

    private static String th(Object body) {
        return "<th>" + String.valueOf(body) + "</th>";
    }

    private static String td(Object body) {
        return "<td>" + String.valueOf(body) + "</td>";
    }
}

