/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Validation;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.cubby.validator.ValidationException;
import org.seasar.cubby.validator.ValidationFailBehaviour;
import org.seasar.cubby.validator.ValidationPhase;
import org.seasar.cubby.validator.ValidationProcessor;
import org.seasar.cubby.validator.ValidationRule;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProcessorImpl
implements ValidationProcessor {
    @Override
    public void process(HttpServletRequest request, Action action, Class<? extends Action> actionClass, Method method) {
        Validation validation = ValidationUtils.getValidation(method);
        if (validation != null) {
            Map params = (Map)CubbyUtils.getAttribute(request, "org.seasar.cubby.params");
            ValidationRules validationRules = ValidationUtils.getValidationRules(action, validation.rules());
            Object formBean = CubbyUtils.getFormBean(action, actionClass, method);
            this.validate(validationRules, params, formBean, action.getErrors());
        }
    }

    public void validate(ValidationRules validationRules, Map<String, Object[]> params, Object form, ActionErrors errors) {
        for (ValidationPhase validationPhase : validationRules.getValidationPhases()) {
            this.validate(validationRules, validationPhase, params, form, errors);
        }
    }

    public void validate(ValidationRules validationRules, ValidationPhase validationPhase, Map<String, Object[]> params, Object form, ActionErrors errors) {
        Collection<ValidationRule> phaseValidationRules = validationRules.getPhaseValidationRules(validationPhase);
        if (validationRules != null) {
            for (ValidationRule validationRule : phaseValidationRules) {
                validationRule.apply(params, form, errors);
            }
            if (!errors.isEmpty()) {
                throw new ValidationException();
            }
        }
    }

    @Override
    public ActionResult handleValidationException(ValidationException e, HttpServletRequest request, Action action, Method method) {
        request.setAttribute("org.seasar.cubby.validationFail", (Object)Boolean.TRUE);
        ValidationFailBehaviour behaviour = e.getBehaviour();
        return behaviour.getActionResult(action, method);
    }
}

