/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.dao;

import java.util.List;

import org.seasar.codegen.sample.entity.DefaultExample;
import org.seasar.codegen.sample.condition.DefaultExampleCondition;
/**
 * DEFAULT_EXAMPLEテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはDefaultExampleDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = DefaultExample.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface DefaultExampleCore {

	/**
	 * DEFAULT_EXAMPLEのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	
	public List<DefaultExample> getAllDefaultExample();



	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<DefaultExample> find(DefaultExampleCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public DefaultExample soleMatch(DefaultExampleCondition condition);

	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(DefaultExample entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<DefaultExample> entityList);

}

