/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * NO_PKテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class NoPkCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	NoPkCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public NoPkCondition() {
		this.alias = "NO_PK";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * カラム１の検索条件を返します。
	 * @return カラム１の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectCol1() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"COL_1", getClass()));
	}


	/**
	 * カラム２の検索条件を返します。
	 * @return カラム２の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectCol2() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"COL_2", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
