/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.OnMemoryEntityResolver;
import org.jiemamy.dddbase.Repository;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnMemoryRepository<T extends Entity>
extends OnMemoryEntityResolver<T>
implements Repository<T> {
    @Override
    public OnMemoryRepository<T> clone() {
        OnMemoryRepository clone = (OnMemoryRepository)super.clone();
        return clone;
    }

    @Override
    public T delete(EntityRef<? extends T> ref) {
        Validate.notNull(ref);
        Map storage = this.getStorage();
        if (!storage.containsKey(ref.getReferentId())) {
            throw new EntityNotFoundException("id=" + ref.getReferentId());
        }
        return (T)((Entity)this.getStorage().remove(ref.getReferentId()));
    }

    @Override
    public Set<T> getEntitiesAsSet() {
        return MutationMonitor.monitor(CloneUtil.cloneEntityHashSet(this.getStorage().values()));
    }

    @Override
    public T store(T entity) {
        Validate.notNull(entity);
        this.chechConsistency(entity);
        Entity clone = entity.clone();
        return (T)this.getStorage().put(clone.getId(), clone);
    }

    int managedAllEntityCount() {
        HashSet collector = Sets.newHashSet();
        for (Entity entity : this.getStorage().values()) {
            this.collectAllId(entity, collector);
        }
        return collector.size();
    }

    int managedMainEntityCount() {
        return this.getStorage().size();
    }

    private void chechConsistency(T entityToAdd) {
        HashMap copy = Maps.newHashMap(this.getStorage());
        copy.remove(entityToAdd.getId());
        Set<UUID> idsToAdd = this.collectAllId((Entity)entityToAdd, (Set<UUID>)new HashSet<UUID>());
        HashSet base = Sets.newHashSet();
        for (Entity entity : copy.values()) {
            this.collectAllId(entity, base);
        }
        base.retainAll(idsToAdd);
        if (base.size() > 0) {
            throw new IllegalArgumentException("collision " + base);
        }
    }

    private Set<UUID> collectAllId(Entity entity, Set<UUID> collector) {
        collector.add(entity.getId());
        for (Entity entity2 : entity.getSubEntities()) {
            this.collectAllId(entity2, collector);
        }
        return collector;
    }
}

