/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.BeanEnhancer;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.Dbms;
import org.seasar.dao.NullBean;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.RelationPropertyTypeFactory;
import org.seasar.dao.RelationPropertyTypeFactoryBuilder;
import org.seasar.dao.TableNaming;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.NullBeanMetaData;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;

public class BeanMetaDataFactoryImpl
implements BeanMetaDataFactory {
    public static final String annotationReaderFactory_BINDING = "bindingType=must";
    public static final String dataSource_BINDING = "bindingType=must";
    public static final String daoNamingConvention_BINDING = "bindingType=must";
    public static final String beanEnhancer_BINDING = "bindingType=must";
    public static final String tableNaming_BINDING = "bindingType=must";
    public static final String propertyTypeFactoryBuilder_BINDING = "bindingType=must";
    public static final String relationPropertyTypeFactoryBuilder_BINDING = "bindingType=must";
    protected AnnotationReaderFactory annotationReaderFactory;
    protected DataSource dataSource;
    protected DaoNamingConvention daoNamingConvention;
    protected BeanEnhancer beanEnhancer;
    protected TableNaming tableNaming;
    protected PropertyTypeFactoryBuilder propertyTypeFactoryBuilder;
    protected RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder;

    public BeanMetaData createBeanMetaData(Class daoInterface, Class beanClass) {
        if (NullBean.class == beanClass) {
            return new NullBeanMetaData(daoInterface);
        }
        return this.createBeanMetaData(beanClass);
    }

    public BeanMetaData createBeanMetaData(Class beanClass) {
        return this.createBeanMetaData(beanClass, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanMetaData createBeanMetaData(Class beanClass, int relationNestLevel) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            DatabaseMetaData metaData = ConnectionUtil.getMetaData((Connection)con);
            BeanMetaData beanMetaData = this.createBeanMetaData(metaData, beanClass, relationNestLevel);
            return beanMetaData;
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
    }

    public BeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class beanClass, int relationNestLevel) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        BeanEnhancer enhancer = this.getBeanEnhancer();
        Class originalBeanClass = enhancer.getOriginalClass(beanClass);
        Dbms dbms = this.getDbms(dbMetaData);
        boolean stopRelationCreation = this.isLimitRelationNestLevel(relationNestLevel);
        BeanAnnotationReader bar = this.annotationReaderFactory.createBeanAnnotationReader(originalBeanClass);
        String versionNoPropertyName = this.getVersionNoPropertyName(bar);
        String timestampPropertyName = this.getTimestampPropertyName(bar);
        PropertyTypeFactory ptf = this.createPropertyTypeFactory(originalBeanClass, bar, dbMetaData, dbms);
        RelationPropertyTypeFactory rptf = this.createRelationPropertyTypeFactory(originalBeanClass, bar, dbMetaData, relationNestLevel, stopRelationCreation);
        BeanMetaDataImpl bmd = this.createBeanMetaDataImpl();
        bmd.setDbms(dbms);
        bmd.setBeanAnnotationReader(bar);
        bmd.setVersionNoPropertyName(versionNoPropertyName);
        bmd.setTimestampPropertyName(timestampPropertyName);
        bmd.setBeanClass(originalBeanClass);
        bmd.setTableNaming(this.tableNaming);
        bmd.setPropertyTypeFactory(ptf);
        bmd.setRelationPropertyTypeFactory(rptf);
        bmd.initialize();
        Class enhancedBeanClass = enhancer.enhanceBeanClass(beanClass, versionNoPropertyName, timestampPropertyName);
        bmd.setModifiedPropertySupport(enhancer.getSupporter());
        bmd.setBeanClass(enhancedBeanClass);
        return bmd;
    }

    protected String getVersionNoPropertyName(BeanAnnotationReader beanAnnotationReader) {
        String defaultName = this.getDaoNamingConvention().getVersionNoPropertyName();
        String name = beanAnnotationReader.getVersionNoPropertyName();
        return name != null ? name : defaultName;
    }

    protected String getTimestampPropertyName(BeanAnnotationReader beanAnnotationReader) {
        String defaultName = this.getDaoNamingConvention().getTimestampPropertyName();
        String name = beanAnnotationReader.getTimestampPropertyName();
        return name != null ? name : defaultName;
    }

    protected PropertyTypeFactory createPropertyTypeFactory(Class originalBeanClass, BeanAnnotationReader beanAnnotationReader, DatabaseMetaData databaseMetaData, Dbms dbms) {
        return this.propertyTypeFactoryBuilder.build(originalBeanClass, beanAnnotationReader, dbms, databaseMetaData);
    }

    protected RelationPropertyTypeFactory createRelationPropertyTypeFactory(Class originalBeanClass, BeanAnnotationReader beanAnnotationReader, DatabaseMetaData databaseMetaData, int relationNestLevel, boolean isStopRelationCreation) {
        return this.relationPropertyTypeFactoryBuilder.build(originalBeanClass, beanAnnotationReader, databaseMetaData, relationNestLevel, isStopRelationCreation);
    }

    protected Dbms getDbms() {
        return DbmsManager.getDbms(this.dataSource);
    }

    protected Dbms getDbms(DatabaseMetaData dbMetaData) {
        return DbmsManager.getDbms(dbMetaData);
    }

    protected BeanMetaDataImpl createBeanMetaDataImpl() {
        return new BeanMetaDataImpl();
    }

    protected boolean isLimitRelationNestLevel(int relationNestLevel) {
        return relationNestLevel == this.getLimitRelationNestLevel();
    }

    protected int getLimitRelationNestLevel() {
        return 1;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public DaoNamingConvention getDaoNamingConvention() {
        return this.daoNamingConvention;
    }

    public void setDaoNamingConvention(DaoNamingConvention daoNamingConvention) {
        this.daoNamingConvention = daoNamingConvention;
    }

    public BeanEnhancer getBeanEnhancer() {
        return this.beanEnhancer;
    }

    public void setBeanEnhancer(BeanEnhancer beanEnhancer) {
        this.beanEnhancer = beanEnhancer;
    }

    public TableNaming getTableNaming() {
        return this.tableNaming;
    }

    public void setTableNaming(TableNaming tableNameConverter) {
        this.tableNaming = tableNameConverter;
    }

    public void setPropertyTypeFactoryBuilder(PropertyTypeFactoryBuilder propertyTypeFactoryBuilder) {
        this.propertyTypeFactoryBuilder = propertyTypeFactoryBuilder;
    }

    public void setRelationPropertyTypeFactoryBuilder(RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder) {
        this.relationPropertyTypeFactoryBuilder = relationPropertyTypeFactoryBuilder;
    }
}

