/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.servicemanager.impl;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.starlogic.servicemanager.ExecuteService;
import jp.starlogic.servicemanager.OneService;
import jp.starlogic.servicemanager.ServiceMonitor;
import org.seasar.framework.container.S2Container;

public class ServiceMonitorImpl
implements ServiceMonitor {
    private Map services = new HashMap();
    private List keyList = new ArrayList();
    private S2Container container;

    public void updateStatus(String serviceName, int status) {
        this.updateStatus(serviceName, status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(String serviceName, int status, Throwable throwable) {
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            if (this.services.containsKey(serviceName)) {
                ServiceMonitor.ServiceInfo info = (ServiceMonitor.ServiceInfo)this.services.get(serviceName);
                info.setStatus(status);
                info.setLastThrowable(throwable);
                info.setStatusUpdateTime(GregorianCalendar.getInstance().getTimeInMillis());
            }
        }
    }

    public Throwable getServiceLastThrowable(String serviceName) {
        return this.getServiceInfo(serviceName).getLastThrowable();
    }

    public int getServiceStatus(String serviceName) {
        return this.getServiceInfo(serviceName).getStatus();
    }

    public OneService getOneService(String serviceName) {
        return this.getServiceInfo(serviceName).getOneService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceMonitor.ServiceInfo getServiceInfo(String serviceName) {
        ServiceMonitor.ServiceInfo info = null;
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            if (!this.services.containsKey(serviceName)) {
                this.addService(serviceName);
            }
            if (this.services.containsKey(serviceName)) {
                info = (ServiceMonitor.ServiceInfo)((ServiceMonitor.ServiceInfo)this.services.get(serviceName)).clone();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread(String serviceName) {
        ServiceMonitor.ServiceInfo info = this.getServiceInfo(serviceName);
        Thread thread = null;
        thread = new Thread(info.getExecuteService());
        info.getExecuteService().clear();
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            info = (ServiceMonitor.ServiceInfo)this.services.get(serviceName);
            info.setThread(thread);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(String serviceName, OneService oneService) {
        if (oneService == null) {
            return;
        }
        ServiceMonitor.ServiceInfo info = new ServiceMonitor.ServiceInfo();
        info.setServiceName(serviceName);
        ExecuteService executeService = this.getExecuteService(serviceName, oneService);
        executeService.setServiceName(serviceName);
        Thread thread = new Thread(executeService);
        info.setExecuteService(executeService);
        info.setOneService(oneService);
        info.setThread(thread);
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            this.services.put(serviceName, info);
            this.keyList.add(serviceName);
        }
    }

    protected ExecuteService getExecuteService(String serviceName, OneService oneService) {
        return (ExecuteService)this.container.getComponent((Object)ExecuteService.class);
    }

    public void addService(String serviceName) {
        OneService oneService = (OneService)this.container.getComponent((Object)serviceName);
        this.addService(serviceName, oneService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServiceNames() {
        ArrayList keys = new ArrayList();
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            keys.addAll(this.keyList);
        }
        return keys;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminate(String serviceName, boolean isTerminate) {
        ServiceMonitorImpl serviceMonitorImpl = this;
        synchronized (serviceMonitorImpl) {
            if (this.services.containsKey(serviceName)) {
                ServiceMonitor.ServiceInfo info = (ServiceMonitor.ServiceInfo)this.services.get(serviceName);
                info.setTerminate(isTerminate);
            }
        }
    }

    public void setTerminate(String serviceName) {
        this.setTerminate(serviceName, true);
    }

    public boolean getIsTerminate(String serviceName) {
        return this.getServiceInfo(serviceName).isTerminate();
    }
}

