/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.tiger.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.AbstractBeanMetaDataResultSetHandler;
import org.seasar.dao.impl.RelationKey;
import org.seasar.dao.impl.RelationRowCache;
import org.seasar.dao.tiger.FetchHandler;
import org.seasar.framework.beans.PropertyDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchBeanMetaDataResultSetHandler
extends AbstractBeanMetaDataResultSetHandler {
    protected FetchHandler fetchHandler;

    public FetchBeanMetaDataResultSetHandler(BeanMetaData beanMetaData, RowCreator rowCreator, RelationRowCreator relationRowCreator, FetchHandler<?> fetchHandler) {
        super(beanMetaData, rowCreator, relationRowCreator);
        this.fetchHandler = fetchHandler;
    }

    public Object handle(ResultSet rs) throws SQLException {
        Set columnNames = this.createColumnNames(rs.getMetaData());
        Map propertyCache = null;
        Map relationPropertyCache = null;
        int relSize = this.getBeanMetaData().getRelationPropertyTypeSize();
        RelationRowCache relRowCache = new RelationRowCache(relSize);
        int count = 0;
        while (rs.next()) {
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(columnNames);
            }
            if (relationPropertyCache == null) {
                relationPropertyCache = this.createRelationPropertyCache(columnNames);
            }
            Object row = this.createRow(rs, propertyCache);
            for (int i = 0; i < relSize; ++i) {
                RelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt == null) continue;
                Object relationRow = null;
                HashMap relKeyValues = new HashMap();
                RelationKey relKey = this.createRelationKey(rs, rpt, columnNames, relKeyValues);
                if (relKey != null && (relationRow = relRowCache.getRelationRow(i, relKey)) == null) {
                    relationRow = this.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
                    relRowCache.addRelationRow(i, relKey, relationRow);
                }
                if (relationRow == null) continue;
                PropertyDesc pd = rpt.getPropertyDesc();
                pd.setValue(row, relationRow);
                this.postCreateRow(relationRow);
            }
            this.postCreateRow(row);
            ++count;
            if (this.fetchHandler.execute(row)) continue;
            break;
        }
        return count;
    }
}

