/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dialect.ReservedWordsChecker;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdentifierValidator
extends AbstractValidator {
    private Pattern identifierPattern;
    private ReservedWordsChecker reservedWords;

    public AbstractIdentifierValidator(String patternString, ReservedWordsChecker reservedWords) {
        Validate.notNull((Object)patternString);
        Validate.notNull((Object)reservedWords);
        this.identifierPattern = Pattern.compile(patternString);
        this.reservedWords = reservedWords;
    }

    @Override
    public Collection<? extends Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (DbObject dbObject : context.getDbObjects()) {
            this.collectProblem(dbObject, dbObject.getName(), problems, false);
            if (!(dbObject instanceof JmTable)) continue;
            JmTable table = (JmTable)dbObject;
            for (JmColumn jmColumn : table.getColumns()) {
                this.collectProblem((Entity)jmColumn, jmColumn.getName(), problems, false);
            }
            for (JmConstraint jmConstraint : table.getConstraints()) {
                this.collectProblem(jmConstraint, jmConstraint.getName(), problems, true);
            }
        }
        return problems;
    }

    int collectProblem(Entity entity, String name, Collection<Problem> result, boolean emptyValid) {
        int before = result.size();
        if (StringUtils.isEmpty((String)name)) {
            if (emptyValid) {
                return 0;
            }
            result.add(new EmptyNameProblem(entity));
            return 1;
        }
        if (!this.identifierPattern.matcher(name).matches()) {
            result.add(new InvalidNameProblem(entity, name, this.identifierPattern));
        }
        if (this.reservedWords.isReserved(name)) {
            result.add(new ReservedWordProblem(entity, name));
        }
        return result.size() - before;
    }

    static class ReservedWordProblem
    extends AbstractProblem {
        public ReservedWordProblem(Entity target, String name) {
            super(target, "E0020", new Object[]{name});
        }
    }

    static class InvalidNameProblem
    extends AbstractProblem {
        public InvalidNameProblem(Entity target, String name, Pattern pattern) {
            super(target, "E0010", new Object[]{name, pattern.pattern()});
        }
    }

    static class EmptyNameProblem
    extends AbstractProblem {
        public EmptyNameProblem(Entity target) {
            super(target, "E0011");
        }
    }
}

