/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.postgresql;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jiemamy.dialect.AbstractDialect;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.Necessity;
import org.jiemamy.dialect.SqlEmitter;
import org.jiemamy.dialect.TokenResolver;
import org.jiemamy.dialect.postgresql.PostgreSqlDatabaseMetadataParser;
import org.jiemamy.dialect.postgresql.PostgreSqlEmitter;
import org.jiemamy.dialect.postgresql.PostgreSqlIdentifierValidator;
import org.jiemamy.dialect.postgresql.PostgreSqlTokenResolver;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.validator.CompositeValidator;
import org.jiemamy.validator.Validator;

public class PostgreSqlDialect
extends AbstractDialect {
    private static List<AbstractDialect.Entry> typeEntries = Lists.newArrayList();

    public PostgreSqlDialect() {
        super("jdbc:postgresql://localhost:5432/", typeEntries);
    }

    public DatabaseMetadataParser getDatabaseMetadataParser() {
        return new PostgreSqlDatabaseMetadataParser(this);
    }

    public String getName() {
        return "PostgreSQL 8.1";
    }

    public SqlEmitter getSqlEmitter() {
        return new PostgreSqlEmitter((Dialect)this, (TokenResolver)new PostgreSqlTokenResolver());
    }

    public Validator getValidator() {
        CompositeValidator validator = (CompositeValidator)super.getValidator();
        validator.getValidators().add(new PostgreSqlIdentifierValidator());
        return validator;
    }

    static {
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER, "INTEGER", new String[]{"int4"}), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER, "BIGINT", new String[]{"int8"}), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.SMALLINT)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.NUMERIC), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DECIMAL)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.FLOAT, "REAL", new String[0]), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.REAL)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DOUBLE, "DOUBLE PRECISION", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BIT), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CHARACTER), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.VARCHAR), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CLOB, "TEXT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BLOB, "BYTEA", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.VARBIT), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BOOLEAN)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DATE)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIME), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.WITH_TIMEZONE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIMESTAMP), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.WITH_TIMEZONE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTERVAL)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "UUID", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "MACADDR", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "MONEY", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "INET", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "CIDR", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "XML", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "LINE", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "LSEG", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "CIRCLE", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "BOX", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "PATH", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "POINT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "POLYGON", new String[0])));
    }
}

