/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class IndexInfoMeta {
    public final String tableCat;
    public final String tableSchem;
    public final String tableName;
    public final boolean nonUnique;
    public final String indexQualifier;
    public final String indexName;
    public final IndexType type;
    public final short ordinalPosition;
    public final String columnName;
    public final SortSequence ascOrDesc;
    public final int cardinality;
    public final int pages;
    public final String filterCondition;

    public IndexInfoMeta(ResultSet indexInfo) {
        Validate.notNull((Object)indexInfo);
        this.tableCat = ResultSetUtil.getValue(String.class, indexInfo, "TABLE_CAT", null);
        this.tableSchem = ResultSetUtil.getValue(String.class, indexInfo, "TABLE_SCHEM", null);
        this.tableName = ResultSetUtil.getValue(String.class, indexInfo, "TABLE_NAME", null);
        this.nonUnique = ResultSetUtil.getValue(Boolean.TYPE, indexInfo, "NON_UNIQUE", Boolean.valueOf(false));
        this.indexQualifier = ResultSetUtil.getValue(String.class, indexInfo, "INDEX_QUALIFIER", null);
        this.indexName = ResultSetUtil.getValue(String.class, indexInfo, "INDEX_NAME", null);
        this.type = IndexType.getIndexType((Short)ResultSetUtil.getValue(Short.TYPE, indexInfo, "TYPE", null));
        this.ordinalPosition = ResultSetUtil.getValue(Short.TYPE, indexInfo, "ORDINAL_POSITION", Short.valueOf((short)0));
        this.columnName = ResultSetUtil.getValue(String.class, indexInfo, "COLUMN_NAME", null);
        this.ascOrDesc = SortSequence.getSortSequence(ResultSetUtil.getValue(String.class, indexInfo, "ASC_OR_DESC", null));
        this.cardinality = ResultSetUtil.getValue(Integer.TYPE, indexInfo, "CARDINALITY", Integer.valueOf(0));
        this.pages = ResultSetUtil.getValue(Integer.TYPE, indexInfo, "PAGES", Integer.valueOf(0));
        this.filterCondition = ResultSetUtil.getValue(String.class, indexInfo, "FILTER_CONDITION", null);
        assert (this.tableName != null);
        assert (this.type != null);
        assert (this.ascOrDesc != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortSequence {
        ASC("A"),
        DESC("D");

        private String value;

        private static SortSequence getSortSequence(String value) {
            for (SortSequence sortSequence : SortSequence.values()) {
                if (!sortSequence.value.equals(value)) continue;
                return sortSequence;
            }
            return null;
        }

        private SortSequence(String value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        STATISTIC(0),
        CLUSTERED(1),
        HASHED(2),
        OTHER(3);

        private int value;

        private static IndexType getIndexType(short value) {
            for (IndexType indexType : IndexType.values()) {
                if (indexType.value != value) continue;
                return indexType;
            }
            return null;
        }

        private IndexType(int value) {
            this.value = value;
        }
    }
}

