/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public final class JmStringUtil {
    private static final int REPLACE_BUFF_SIZE = 100;
    public static final String[] EMPTY_STRINGS = new String[0];
    private static final Pattern JAVA_CLASS_NAME_PATTERN = Pattern.compile("^[A-Z][a-zA-Z0-9]*$");
    private static final Pattern JAVA_CLASS_NAME_IGNORE_PATTERN = Pattern.compile("^[A-Z]+$");
    private static final Pattern JAVA_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static final Pattern SQL_NAME_PATTERN = Pattern.compile("^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$");

    public static void appendHex(StringBuilder buf, byte i) {
        Validate.notNull((Object)buf);
        buf.append(Character.forDigit(i >> 4 & 0xF, 16));
        buf.append(Character.forDigit(i & 0xF, 16));
    }

    public static void appendHex(StringBuilder buf, int i) {
        Validate.notNull((Object)buf);
        for (int shift = 24; shift >= 0; shift -= 8) {
            String str = Integer.toHexString(i >> shift & 0xFF);
            if (str.length() == 1) {
                buf.append('0');
            }
            buf.append(str);
        }
    }

    public static String appendSqlPrefix(String sqlName, String prefix) {
        if (JmStringUtil.isEmpty(sqlName) || JmStringUtil.isEmpty(prefix)) {
            return sqlName;
        }
        return prefix.replaceFirst("[^_]$", "$0_").toUpperCase(Locale.getDefault()) + sqlName;
    }

    public static String capitalize(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return str;
        }
        char[] ch = str.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        return new String(ch);
    }

    public static String capitalizeAsJavaBeans(String name) {
        return JmStringUtil.capitalize(name);
    }

    public static boolean containsIgnoreCase(String[] array, String stringToFind) {
        return JmStringUtil.indexOfIgnoreCase(array, stringToFind) != -1;
    }

    public static String decapitalize(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return str;
        }
        char[] ch = str.toCharArray();
        ch[0] = Character.toLowerCase(ch[0]);
        return new String(ch);
    }

    public static String decapitalizeAsJavaBeans(String name) {
        if (JmStringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return name;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean endsWithIgnoreCase(String target, String suffix) {
        int suffixLength;
        if (target == null || suffix == null) {
            return false;
        }
        int targetLength = target.length();
        if (targetLength < (suffixLength = suffix.length())) {
            return false;
        }
        String s1 = target.substring(targetLength - suffixLength);
        return s1.equalsIgnoreCase(suffix);
    }

    public static boolean equals(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    public static boolean equalsIgnoreCase(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equalsIgnoreCase(target2);
    }

    public static int indexOfIgnoreCase(String[] array, String stringToFind) {
        return JmStringUtil.indexOfIgnoreCase(array, stringToFind, 0);
    }

    public static int indexOfIgnoreCase(String[] array, String stringToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (stringToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!stringToFind.equalsIgnoreCase(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isBlank(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isJavaClassName(String name) {
        if (JmStringUtil.isEmpty(name)) {
            return false;
        }
        return JAVA_CLASS_NAME_PATTERN.matcher(name).matches() && !JAVA_CLASS_NAME_IGNORE_PATTERN.matcher(name).matches();
    }

    public static boolean isJavaName(String name) {
        if (JmStringUtil.isEmpty(name)) {
            return false;
        }
        return JAVA_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isNotBlank(String str) {
        return !JmStringUtil.isBlank(str);
    }

    public static boolean isNotEmpty(String text) {
        return !JmStringUtil.isEmpty(text);
    }

    public static boolean isNumber(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char chr = s.charAt(i);
            if (chr >= '0' && '9' >= chr) continue;
            return false;
        }
        return true;
    }

    public static boolean isSqlName(String name) {
        if (JmStringUtil.isEmpty(name)) {
            return false;
        }
        return SQL_NAME_PATTERN.matcher(name).matches();
    }

    public static String ltrim(String text) {
        return JmStringUtil.ltrim(text, null);
    }

    public static String ltrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        return text.substring(pos);
    }

    public static String removeSqlPrefix(String sqlName, String prefix) {
        if (JmStringUtil.isEmpty(sqlName) || JmStringUtil.isEmpty(prefix)) {
            return sqlName;
        }
        return sqlName.replaceFirst(prefix + "_?", "");
    }

    public static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return text;
        }
        StringBuilder buf = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public static String rtrim(String text) {
        return JmStringUtil.rtrim(text, null);
    }

    public static String rtrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static String[] split(String str, String delim) {
        if (JmStringUtil.isEmpty(str)) {
            return EMPTY_STRINGS;
        }
        if (JmStringUtil.isEmpty(delim)) {
            return new String[]{str};
        }
        return str.split(delim);
    }

    public static boolean startsWithIgnoreCase(String target, String prefix) {
        int prefixLength;
        if (target == null || prefix == null) {
            return false;
        }
        int targetLength = target.length();
        if (targetLength < (prefixLength = prefix.length())) {
            return false;
        }
        String s1 = target.substring(0, prefix.length());
        return s1.equalsIgnoreCase(prefix);
    }

    public static String substringFromLast(String str, String separator) {
        if (JmStringUtil.isEmpty(str) || JmStringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringToLast(String str, String separator) {
        if (JmStringUtil.isEmpty(str) || JmStringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(pos + 1, str.length());
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            JmStringUtil.appendHex(sb, bytes[i]);
        }
        return sb.toString();
    }

    public static String toHex(int i) {
        StringBuilder buf = new StringBuilder();
        JmStringUtil.appendHex(buf, i);
        return buf.toString();
    }

    public static String toJavaClassName(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return str;
        }
        return JmStringUtil.capitalize(JmStringUtil.toJavaName(str));
    }

    public static String toJavaName(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return str;
        }
        if (JmStringUtil.isJavaName(str)) {
            return str;
        }
        if (JmStringUtil.isJavaClassName(str)) {
            return JmStringUtil.decapitalizeAsJavaBeans(str);
        }
        String upper = !JmStringUtil.isSqlName(str) ? str.toUpperCase(Locale.getDefault()) : str;
        StringBuilder sb = new StringBuilder(upper.toLowerCase(Locale.getDefault()));
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '_') continue;
            sb.deleteCharAt(i);
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public static String toSqlName(String str) {
        if (JmStringUtil.isEmpty(str)) {
            return str;
        }
        if (JmStringUtil.isSqlName(str)) {
            return str;
        }
        if (!(JmStringUtil.isJavaClassName(str) || JmStringUtil.isJavaName(str))) {
            return str.toUpperCase(Locale.getDefault());
        }
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                sb.insert(i++, "_");
                continue;
            }
            sb.setCharAt(i, Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public static String trimPrefix(String text, String prefix) {
        if (text == null) {
            return null;
        }
        if (prefix == null) {
            return text;
        }
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String trimSuffix(String text, String suffix) {
        if (text == null) {
            return null;
        }
        if (suffix == null) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    private JmStringUtil() {
    }
}

