/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.internal.impl;

import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;

/**
 * @author azusa
 * 
 */
public class FromToOptionTest extends TestCase {

    /*
     * (非 Javadoc)
     * 
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * {@link org.seasar.codegen.lib.internal.impl.FromToOption#filterFromDate(java.util.Date)}
     * のためのテスト・メソッド。
     */
    public void testFilterFromDate() {
        Date date = createDate();
        Date result = FromToOption.filterFromDate(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        assertEquals(2009, cal.get(Calendar.YEAR));
        assertEquals(2, cal.get(Calendar.MONTH));
        assertEquals(1, cal.get(Calendar.DAY_OF_MONTH));
        assertEquals(0, cal.get(Calendar.HOUR));
        assertEquals(0, cal.get(Calendar.MINUTE));
        assertEquals(0, cal.get(Calendar.SECOND));
        assertEquals(0, cal.get(Calendar.MILLISECOND));

    }

    /**
     * {@link org.seasar.codegen.lib.internal.impl.FromToOption#filterToDate(java.util.Date)}
     * のためのテスト・メソッド。
     */
    public void testFilterToDate() {
        Date date = createDate();
        Date result = FromToOption.filterToDate(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(result);
        assertEquals(2009, cal.get(Calendar.YEAR));
        assertEquals(2, cal.get(Calendar.MONTH));
        assertEquals(2, cal.get(Calendar.DAY_OF_MONTH));
        assertEquals(0, cal.get(Calendar.HOUR));
        assertEquals(0, cal.get(Calendar.MINUTE));
        assertEquals(0, cal.get(Calendar.SECOND));
        assertEquals(0, cal.get(Calendar.MILLISECOND));
    }

    private Date createDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, 2009);
        calendar.set(Calendar.MONTH, 2);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }
}
