/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;

import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Operator;

/**
 * @author azusa
 * 
 */
public class DateConditionElementImplTest extends TestCase {

    private ConditionResultImpl conditionResultImpl = new ConditionResultImpl();

    private Column column1 = new ColumnImpl("aaa", "bbb", null);

    private DateConditionElementImpl dateConditionElementImpl = new DateConditionElementImpl(conditionResultImpl,
            column1);

    /*
     * (非 Javadoc)
     * 
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * {@link org.seasar.codegen.lib.impl.DateConditionElementImpl#dateFrom(java.util.Date)}
     * のためのテスト・メソッド。
     */
    public void testDateFrom() {
        Date date = createDate(2009, 1, 12);
        dateConditionElementImpl.dateFrom(date);
        BindValue bv = conditionResultImpl.getBindValues().get(0);
        assertEquals(column1, bv.getColumn());
        assertEquals(Operator.MORETHAN, bv.getOperator());
        Date bindDate = (Date) bv.getArgs()[0];
        Calendar cal = Calendar.getInstance();
        cal.setTime(bindDate);
        assertEquals(2009, cal.get(Calendar.YEAR));
        assertEquals(1, cal.get(Calendar.MONTH));
        assertEquals(12, cal.get(Calendar.DAY_OF_MONTH));
        assertEquals(0, cal.get(Calendar.SECOND));
        assertEquals(0, cal.get(Calendar.MILLISECOND));

    }

    /**
     * {@link org.seasar.codegen.lib.impl.DateConditionElementImpl#dateFromTo(java.util.Date, java.util.Date)}
     * のためのテスト・メソッド。
     */
    public void testDateFromTo() {
        Date from = createDate(2009, 1, 12);
        Date to = createDate(2009, 1, 13);

        dateConditionElementImpl.dateFromTo(from, to);
        {
            BindValue bv = conditionResultImpl.getBindValues().get(0);
            assertEquals(column1, bv.getColumn());
            assertEquals(Operator.MORETHAN, bv.getOperator());
            Date bindDate = (Date) bv.getArgs()[0];
            Calendar cal = Calendar.getInstance();
            cal.setTime(bindDate);
            assertEquals(2009, cal.get(Calendar.YEAR));
            assertEquals(1, cal.get(Calendar.MONTH));
            assertEquals(12, cal.get(Calendar.DAY_OF_MONTH));
            assertEquals(0, cal.get(Calendar.SECOND));
            assertEquals(0, cal.get(Calendar.MILLISECOND));
        }
        {
            BindValue bv = conditionResultImpl.getBindValues().get(1);
            assertEquals(column1, bv.getColumn());
            assertEquals(Operator.LESS, bv.getOperator());
            Date bindDate = (Date) bv.getArgs()[0];
            Calendar cal = Calendar.getInstance();
            cal.setTime(bindDate);
            assertEquals(2009, cal.get(Calendar.YEAR));
            assertEquals(1, cal.get(Calendar.MONTH));
            assertEquals(14, cal.get(Calendar.DAY_OF_MONTH));
            assertEquals(0, cal.get(Calendar.SECOND));
            assertEquals(0, cal.get(Calendar.MILLISECOND));
        }
    }

    /**
     * {@link org.seasar.codegen.lib.impl.DateConditionElementImpl#dateTo(java.util.Date)}
     * のためのテスト・メソッド。
     */
    public void testDateTo() {
        Date date = createDate(2009, 1, 12);
        dateConditionElementImpl.dateTo(date);
        BindValue bv = conditionResultImpl.getBindValues().get(0);
        assertEquals(column1, bv.getColumn());
        assertEquals(Operator.LESS, bv.getOperator());
        Date bindDate = (Date) bv.getArgs()[0];
        Calendar cal = Calendar.getInstance();
        cal.setTime(bindDate);
        assertEquals(2009, cal.get(Calendar.YEAR));
        assertEquals(1, cal.get(Calendar.MONTH));
        assertEquals(13, cal.get(Calendar.DAY_OF_MONTH));
        assertEquals(0, cal.get(Calendar.SECOND));
        assertEquals(0, cal.get(Calendar.MILLISECOND));
    }

    private Date createDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month);
        calendar.set(Calendar.DAY_OF_MONTH, day);
        return calendar.getTime();
    }

}
