/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * EMP_TABLEテーブルのEntityです。
 * @author S2Dao-CodeGen
 */

@org.seasar.dao.annotation.tiger.Bean(table = "EMP_TABLE", versionNoProperty = "versionno")
public abstract class AbstractEmpTable {

	private Integer empNo;
	private String ename;
	private String job;
	private Integer mgr;
	private java.util.Date hireDate;
	private java.math.BigDecimal sal;
	private java.math.BigDecimal comm;
	private Integer deptNo;
	private java.sql.Timestamp tstamp;
	private Integer versionno;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * 社員番号を返します。
	 * @return 社員番号
	 */
	@org.seasar.dao.annotation.tiger.Id(value = org.seasar.dao.annotation.tiger.IdType.SEQUENCE, sequenceName = "EMPNO")
		@org.seasar.dao.annotation.tiger.Column("EMP_NO")
	public Integer getEmpNo() {
		return empNo;
	}

	/**
	 * 社員番号を設定します。
	 * @param empNo 社員番号
	 */
	public void setEmpNo(Integer empNo) {
		modifiedPropertySet.add("empNo");
		this.empNo = empNo;
	}

	/**
	 * 社員名を返します。
	 * @return 社員名
	 */
	@org.seasar.dao.annotation.tiger.Column("ENAME")
	public String getEname() {
		return ename;
	}

	/**
	 * 社員名を設定します。
	 * @param ename 社員名
	 */
	public void setEname(String ename) {
		modifiedPropertySet.add("ename");
		this.ename = ename;
	}

	/**
	 * 職種を返します。
	 * @return 職種
	 */
	@org.seasar.dao.annotation.tiger.Column("JOB")
	public String getJob() {
		return job;
	}

	/**
	 * 職種を設定します。
	 * @param job 職種
	 */
	public void setJob(String job) {
		modifiedPropertySet.add("job");
		this.job = job;
	}

	/**
	 * 上司を返します。
	 * @return 上司
	 */
	@org.seasar.dao.annotation.tiger.Column("MGR")
	public Integer getMgr() {
		return mgr;
	}

	/**
	 * 上司を設定します。
	 * @param mgr 上司
	 */
	public void setMgr(Integer mgr) {
		modifiedPropertySet.add("mgr");
		this.mgr = mgr;
	}

	/**
	 * 入社日を返します。
	 * @return 入社日
	 */
	@org.seasar.dao.annotation.tiger.Column("HIRE_DATE")
	public java.util.Date getHireDate() {
		return hireDate;
	}

	/**
	 * 入社日を設定します。
	 * @param hireDate 入社日
	 */
	public void setHireDate(java.util.Date hireDate) {
		modifiedPropertySet.add("hireDate");
		this.hireDate = hireDate;
	}

	/**
	 * 給料を返します。
	 * @return 給料
	 */
	@org.seasar.dao.annotation.tiger.Column("SAL")
	public java.math.BigDecimal getSal() {
		return sal;
	}

	/**
	 * 給料を設定します。
	 * @param sal 給料
	 */
	public void setSal(java.math.BigDecimal sal) {
		modifiedPropertySet.add("sal");
		this.sal = sal;
	}

	/**
	 * 歩合給を返します。
	 * @return 歩合給
	 */
	@org.seasar.dao.annotation.tiger.Column("COMM")
	public java.math.BigDecimal getComm() {
		return comm;
	}

	/**
	 * 歩合給を設定します。
	 * @param comm 歩合給
	 */
	public void setComm(java.math.BigDecimal comm) {
		modifiedPropertySet.add("comm");
		this.comm = comm;
	}

	/**
	 * 部署番号を返します。
	 * @return 部署番号
	 */
	@org.seasar.dao.annotation.tiger.Column("DEPT_NO")
	public Integer getDeptNo() {
		return deptNo;
	}

	/**
	 * 部署番号を設定します。
	 * @param deptNo 部署番号
	 */
	public void setDeptNo(Integer deptNo) {
		modifiedPropertySet.add("deptNo");
		this.deptNo = deptNo;
	}

	/**
	 * タイムスタンプを返します。
	 * @return タイムスタンプ
	 */
	@org.seasar.dao.annotation.tiger.Column("TSTAMP")
	public java.sql.Timestamp getTstamp() {
		return tstamp;
	}

	/**
	 * タイムスタンプを設定します。
	 * @param tstamp タイムスタンプ
	 */
	public void setTstamp(java.sql.Timestamp tstamp) {
		modifiedPropertySet.add("tstamp");
		this.tstamp = tstamp;
	}

	/**
	 * バージョン番号を返します。
	 * @return バージョン番号
	 */
	@org.seasar.dao.annotation.tiger.Column("VERSIONNO")
	public Integer getVersionno() {
		return versionno;
	}

	/**
	 * バージョン番号を設定します。
	 * @param versionno バージョン番号
	 */
	public void setVersionno(Integer versionno) {
		modifiedPropertySet.add("versionno");
		this.versionno = versionno;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/empNo=").append(empNo);
		buff.append("/ename=").append(ename);
		buff.append("/job=").append(job);
		buff.append("/mgr=").append(mgr);
		buff.append("/hireDate=").append(hireDate);
		buff.append("/sal=").append(sal);
		buff.append("/comm=").append(comm);
		buff.append("/deptNo=").append(deptNo);
		buff.append("/tstamp=").append(tstamp);
		buff.append("/versionno=").append(versionno);
		buff.append("]");
		return buff.toString();
	}

}
