/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * DETECT_BUGテーブルのEntityです。
 * @author S2Dao-CodeGen
 */

@org.seasar.dao.annotation.tiger.Bean(table = "DETECT_BUG", versionNoProperty = "versionno")
public abstract class AbstractDetectBug {

	private java.sql.Time col1;
	private String col2;
	private String col3 = "";
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * カラム１を返します。
	 * @return カラム１
	 */
	@org.seasar.dao.annotation.tiger.Column("COL_1")
	public java.sql.Time getCol1() {
		return col1;
	}

	/**
	 * カラム１を設定します。
	 * @param col1 カラム１
	 */
	public void setCol1(java.sql.Time col1) {
		modifiedPropertySet.add("col1");
		this.col1 = col1;
	}

	/**
	 * カラム２を返します。
	 * @return カラム２
	 */
	@org.seasar.dao.annotation.tiger.Column("COL_2")
	public String getCol2() {
		return col2;
	}

	/**
	 * カラム２を設定します。
	 * @param col2 カラム２
	 */
	public void setCol2(String col2) {
		modifiedPropertySet.add("col2");
		this.col2 = col2;
	}

	/**
	 * カラム3を返します。
	 * @return カラム3
	 */
	@org.seasar.dao.annotation.tiger.Column("COL_3")
	public String getCol3() {
		return col3;
	}

	/**
	 * カラム3を設定します。
	 * @param col3 カラム3
	 */
	public void setCol3(String col3) {
		modifiedPropertySet.add("col3");
		this.col3 = col3;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/col1=").append(col1);
		buff.append("/col2=").append(col2);
		buff.append("/col3=").append(col3);
		buff.append("]");
		return buff.toString();
	}

}
