/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * DEFAULT_EXAMPLEテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class DefaultExampleCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	DefaultExampleCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public DefaultExampleCondition() {
		this.alias = "DEFAULT_EXAMPLE";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * 実数の検索条件を返します。
	 * @return 実数の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal> selectRealDefault() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<java.math.BigDecimal>(conditionResult, new ColumnImpl(this.alias,"REAL_DEFAULT", getClass()));
	}


	/**
	 * 整数の検索条件を返します。
	 * @return 整数の検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectBigintDefault() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"BIGINT_DEFAULT", getClass()));
	}


	/**
	 * 文字列の検索条件を返します。
	 * @return 文字列の検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectStringDefault() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"STRING_DEFAULT", getClass()));
	}


	/**
	 * 日時上限の検索条件を返します。
	 * @return 日時上限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectDateMax() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"DATE_MAX", getClass()));
	}


	/**
	 * 日時下限の検索条件を返します。
	 * @return 日時下限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectDateMin() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"DATE_MIN", getClass()));
	}


	/**
	 * 日時現在の検索条件を返します。
	 * @return 日時現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectDateCur() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"DATE_CUR", getClass()));
	}


	/**
	 * 日時現在の検索条件を返します。
	 * @return 日時現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectDateNow() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"DATE_NOW", getClass()));
	}


	/**
	 * 時間上限の検索条件を返します。
	 * @return 時間上限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time> selectTimeMax() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time>(conditionResult, new ColumnImpl(this.alias,"TIME_MAX", getClass()));
	}


	/**
	 * 時間下限の検索条件を返します。
	 * @return 時間下限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time> selectTimeMin() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time>(conditionResult, new ColumnImpl(this.alias,"TIME_MIN", getClass()));
	}


	/**
	 * 時間現在の検索条件を返します。
	 * @return 時間現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time> selectTimeCur() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time>(conditionResult, new ColumnImpl(this.alias,"TIME_CUR", getClass()));
	}


	/**
	 * 時間現在の検索条件を返します。
	 * @return 時間現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time> selectTimeNow() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Time>(conditionResult, new ColumnImpl(this.alias,"TIME_NOW", getClass()));
	}


	/**
	 * タイムスタンプ上限の検索条件を返します。
	 * @return タイムスタンプ上限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp> selectTimestampMax() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp>(conditionResult, new ColumnImpl(this.alias,"TIMESTAMP_MAX", getClass()));
	}


	/**
	 * タイムスタンプ下限の検索条件を返します。
	 * @return タイムスタンプ下限の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp> selectTimestampMin() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp>(conditionResult, new ColumnImpl(this.alias,"TIMESTAMP_MIN", getClass()));
	}


	/**
	 * タイムスタンプ現在の検索条件を返します。
	 * @return タイムスタンプ現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp> selectTimestampCur() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp>(conditionResult, new ColumnImpl(this.alias,"TIMESTAMP_CUR", getClass()));
	}


	/**
	 * タイムスタンプ現在の検索条件を返します。
	 * @return タイムスタンプ現在の検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp> selectTimestampNow() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.sql.Timestamp>(conditionResult, new ColumnImpl(this.alias,"TIMESTAMP_NOW", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
