/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.dao;

import java.util.ArrayList;
import java.util.List;

import org.seasar.codegen.sample.entity.NoPk;
import org.seasar.extension.unit.S2TestCase;

public class NoPkDaoTest extends S2TestCase {

    private NoPkDao dao;

    protected void setUp() throws Exception {
        include("org/seasar/codegen/sample/dicon/alldao.dicon");
    }

    public void testInsertTx() throws Exception {
        NoPk dto = new NoPk();
        dto.setCol1(1);
        dto.setCol2("テスト");
        dao.insert(dto);
    }

    public void testInsertBatchTx() throws Exception {
        List<NoPk> list = new ArrayList<NoPk>();
        {
            NoPk dto = new NoPk();
            dto.setCol1(1);
            dto.setCol2("テスト");
            dao.insert(dto);
            list.add(dto);
        }
        {
            NoPk dto = new NoPk();
            dto.setCol1(2);
            dto.setCol2("テスト2");
            dao.insert(dto);
            list.add(dto);
        }
        dao.insertBatch(list);
    }
}
