/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.mysql;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jiemamy.dialect.AbstractDialect;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.Necessity;
import org.jiemamy.dialect.SqlEmitter;
import org.jiemamy.dialect.mysql.MySqlDatabaseMetadataParser;
import org.jiemamy.dialect.mysql.MySqlEmitter;
import org.jiemamy.dialect.mysql.MySqlIdentifierValidator;
import org.jiemamy.dialect.mysql.parameter.MySqlParameterKeys;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.validator.CompositeValidator;
import org.jiemamy.validator.Validator;

public class MySqlDialect
extends AbstractDialect {
    private static List<AbstractDialect.Entry> typeEntries = Lists.newArrayList();

    public MySqlDialect() {
        super("jdbc:mysql://localhost:3306/", typeEntries);
    }

    public DatabaseMetadataParser getDatabaseMetadataParser() {
        return new MySqlDatabaseMetadataParser(this);
    }

    public String getName() {
        return "MySQL 5.0";
    }

    public SqlEmitter getSqlEmitter() {
        return new MySqlEmitter((Dialect)this);
    }

    public Validator getValidator() {
        CompositeValidator validator = (CompositeValidator)super.getValidator();
        validator.getValidators().add(new MySqlIdentifierValidator());
        return validator;
    }

    static {
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER, "MEDIUMINT", new String[0]), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER, "BIGINT", new String[0]), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.SMALLINT), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.SMALLINT, "TINYINT", new String[0]), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.NUMERIC), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DECIMAL), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.FLOAT), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.REAL), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DOUBLE), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
                this.put(MySqlParameterKeys.UNSIGNED, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BIT), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CHARACTER), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.VARCHAR), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CLOB, "TEXT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CLOB, "TINYTEXT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CLOB, "MEDIUMTEXT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.CLOB, "LONGTEXT", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BLOB)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BLOB, "TINYBLOB", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BLOB, "MEDIUMBLOB", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BLOB, "LONGBLOB", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DATE)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIME)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIMESTAMP)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIMESTAMP, "DATETIME", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER, "YEAR", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "BINARY", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "VARBINARY", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "ENUM", new String[0])));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.OTHER, "SET", new String[0])));
    }
}

