/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.swap;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.swap.ReferenceEvent;
import org.jiemamy.utils.swap.ReferenceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReferenceQueueMonitor<T>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ReferenceQueueMonitor.class);
    ReferenceQueue<T> queue;
    List<ReferenceListener> listeners;
    boolean running;

    public ReferenceQueueMonitor(ReferenceQueue<T> queue) {
        Validate.notNull(queue);
        this.queue = queue;
        this.listeners = new ArrayList<ReferenceListener>();
        this.running = true;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Reference<T> ref = this.queue.remove();
                ReferenceEvent event = new ReferenceEvent(ref);
                for (ReferenceListener listener : this.listeners) {
                    listener.referenceModified(event);
                }
            }
            catch (InterruptedException e) {
                logger.info((Marker)LogMarker.LIFECYCLE, "Shutting down because InterruptedException thrown.", (Throwable)e);
                this.running = false;
            }
        }
    }

    void addReferenceListener(ReferenceListener listener) {
        this.listeners.add(listener);
    }
}

