/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyError;
import org.jiemamy.utils.ClassTraversal;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.TraversalHandlerException;
import org.jiemamy.utils.reflect.ClassUtil;
import org.jiemamy.utils.sql.DriverNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DriverUtil {
    private static Logger logger = LoggerFactory.getLogger(DriverUtil.class);

    public static Collection<Class<? extends Driver>> getDriverClasses(URL[] paths) throws IOException {
        Validate.noNullElements((Object[])paths);
        URLClassLoader classLoader = new URLClassLoader(paths);
        ArrayList driverList = Lists.newArrayList();
        for (URL path : paths) {
            try {
                File file = new File(path.toURI());
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                JarFile jarFile = new JarFile(file);
                ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)new GetDriverClassesFromJarHandler(driverList, classLoader));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(path.toString(), e);
            }
            catch (TraversalHandlerException e) {
                logger.error((Marker)LogMarker.DETAIL, "fail to handle jar entry.", (Throwable)e);
            }
        }
        return driverList;
    }

    public static Driver getDriverInstance(URL[] paths, String fqcn) throws InstantiationException, IllegalAccessException, DriverNotFoundException, IOException {
        Validate.noNullElements((Object[])paths);
        Validate.notNull((Object)fqcn);
        Driver driver = null;
        Collection<Class<? extends Driver>> classes = DriverUtil.getDriverClasses(paths);
        for (Class<? extends Driver> clazz : classes) {
            if (!clazz.getName().equals(fqcn)) continue;
            driver = clazz.newInstance();
            break;
        }
        if (driver == null) {
            try {
                driver = (Driver)Class.forName(fqcn).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new DriverNotFoundException(fqcn);
            }
        }
        return driver;
    }

    private DriverUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetDriverClassesFromJarHandler
    implements ClassTraversal.ClassHandler {
        private final Collection<Class<? extends Driver>> driverList;
        private final URLClassLoader classLoader;

        private GetDriverClassesFromJarHandler(Collection<Class<? extends Driver>> driverList, URLClassLoader classLoader) {
            assert (driverList != null);
            assert (classLoader != null);
            this.driverList = driverList;
            this.classLoader = classLoader;
        }

        @Override
        public void processClass(String packageName, String shortClassName) throws TraversalHandlerException {
            String fqcn = ClassUtil.concatName(packageName, shortClassName);
            try {
                Class<?>[] interfaceClasses;
                Class<?> clazz = this.classLoader.loadClass(fqcn);
                for (Class<?> interfaceClass : interfaceClasses = clazz.getInterfaces()) {
                    if (!interfaceClass.equals(Driver.class)) continue;
                    Class<?> driverClass = clazz;
                    this.driverList.add(driverClass);
                }
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException e) {
                throw new JiemamyError("Class must to be in classpath: " + fqcn, e);
            }
            catch (Throwable t) {
                throw new TraversalHandlerException(t);
            }
        }
    }
}

