/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.collection;

import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.collection.EssentialStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayEssentialStack<E>
implements EssentialStack<E> {
    private static final double GROWTH_FACTOR = 1.1;
    private final Stack<E> stack;

    public ArrayEssentialStack() {
        this.stack = new Stack();
    }

    public ArrayEssentialStack(Collection<? extends E> collection) {
        Validate.notNull(collection);
        this.stack = new Stack();
        for (E element : collection) {
            this.stack.push(element);
        }
    }

    public ArrayEssentialStack(EssentialStack<? extends E> source) {
        Validate.notNull(source);
        this.stack = new Stack();
        for (Object element : source) {
            this.stack.push(element);
        }
    }

    @Deprecated
    public ArrayEssentialStack(int initialSize) {
        Validate.isTrue((initialSize >= 0 ? 1 : 0) != 0);
        this.stack = new Stack();
    }

    @Override
    public void clear() {
        this.stack.clear();
    }

    @Override
    public E get(int n) {
        return this.stack.get(n);
    }

    @Override
    public void insert(int index, E element) {
        this.stack.add(index, element);
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.stack.iterator();
    }

    @Override
    public E peek() {
        return this.stack.peek();
    }

    @Override
    public E peek(int n) {
        try {
            return this.stack.get(this.stack.size() - n - 1);
        }
        catch (EmptyStackException e) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size());
        }
    }

    @Override
    public E pop() {
        return this.stack.pop();
    }

    @Override
    public void push(E element) {
        this.stack.push(element);
    }

    @Override
    public boolean remove(E element) {
        return this.stack.remove(element);
    }

    @Override
    public E remove(int n) {
        return this.stack.remove(n);
    }

    @Override
    public EssentialStack<E> reverse() {
        ArrayEssentialStack result = new ArrayEssentialStack();
        for (Object element : this.stack) {
            result.insert(0, element);
        }
        return result;
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    public String toString() {
        return this.stack.toString();
    }
}

