/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class UUIDUtil {
    static Map<String, UUID> cache = Maps.newHashMap();
    private static Logger logger = LoggerFactory.getLogger(UUIDUtil.class);

    public static void clear() {
        cache.clear();
    }

    public static String toShortString(UUID uuid) {
        if (uuid == null) {
            return "null";
        }
        String string = uuid.toString();
        return string.substring(0, 8);
    }

    public static UUID valueOfOrRandom(String name) {
        UUID result;
        if (name == null) {
            result = UUIDUtil.getUUID(null);
            logger.trace((Marker)LogMarker.DETAIL, "Symbolic ID null is mapped to UUID '{}'", (Object)result);
        } else {
            try {
                result = UUID.fromString(name);
            }
            catch (IllegalArgumentException e) {
                result = UUIDUtil.getUUID(name);
                logger.trace((Marker)LogMarker.DETAIL, "Symbolic ID '{}' is mapped to UUID '{}'", (Object)name, (Object)result);
            }
        }
        return result;
    }

    private static UUID getUUID(String name) {
        if (cache.get(name) == null) {
            UUID random = UUID.randomUUID();
            cache.put(name, random);
            logger.info((Marker)LogMarker.DETAIL, "Symbolic ID '{}' is mapped to UUID '{}'", (Object)name, (Object)random);
        }
        return cache.get(name);
    }

    private UUIDUtil() {
    }
}

