/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import org.jiemamy.utils.LogMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class UUIDProvider {
    private Map<String, UUID> cache = Maps.newHashMap();
    private static Logger logger = LoggerFactory.getLogger(UUIDProvider.class);

    public UUID valueOfOrRandom(String name) {
        UUID result;
        if (name == null) {
            result = this.getUUID(null);
            logger.trace((Marker)LogMarker.DETAIL, "Symbolic ID null is mapped to UUID '{}'", (Object)result);
        } else {
            try {
                result = UUID.fromString(name);
            }
            catch (IllegalArgumentException e) {
                result = this.getUUID(name);
                logger.trace((Marker)LogMarker.DETAIL, "Symbolic ID '{}' is mapped to UUID '{}'", (Object)name, (Object)result);
            }
        }
        return result;
    }

    private UUID getUUID(String name) {
        if (this.cache.get(name) == null) {
            UUID random = UUID.randomUUID();
            this.cache.put(name, random);
            logger.info((Marker)LogMarker.DETAIL, "Symbolic ID '{}' is mapped to UUID '{}'", (Object)name, (Object)random);
        }
        return this.cache.get(name);
    }
}

