/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceBundleUtil {
    public static Map<String, String> convertMap(ResourceBundle bundle) {
        Validate.notNull((Object)bundle);
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = bundle.getString(key);
            ret.put(key, value);
        }
        return ret;
    }

    public static Map<String, String> convertMap(String name, Locale locale) {
        Validate.notNull((Object)name);
        ResourceBundle bundle = ResourceBundleUtil.getBundle(name, locale);
        return ResourceBundleUtil.convertMap(bundle);
    }

    public static ResourceBundle getBundle(String name, Locale locale) {
        Validate.notNull((Object)name);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(name, locale);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static ResourceBundle getBundle(String name, Locale locale, ClassLoader classLoader) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)classLoader);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(name, locale, classLoader);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    private ResourceBundleUtil() {
    }
}

