/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;


/**
 * テーブルEMP_TABLEとマッピング関係にあるテーブルに対応するDtoです。
 * @author S2Dao-CodeGen
 */
public abstract class AbstractEmpTableRelation extends AbstractEmpTable {

	private DeptTable deptTableEntity;
	

	/**
	 * DEPT_TABLEに対応するEntityを返します。
	 * @return DEPT_TABLEに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "DEPT_NO:DEPT_ID", relationNo = 0)
	public DeptTable getDeptTableEntity() {
		return this.deptTableEntity;
	}

	/**
	 * DEPT_TABLEに対応するDtoを設定します。
	 * @param deptTableEntity DEPT_TABLEに対応するEntity
	 */
	public void setDeptTableEntity(DeptTable deptTableEntity) {
		this.deptTableEntity = deptTableEntity;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(super.toString());
		buf.append("deptTableEntity").append(deptTableEntity);
		return buf.toString();
	}

}
