/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.exception;

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileNotFoundException;

import org.junit.Test;

public class FileNotFoundRuntimeExceptionTest {

    /**
     * TODO for azusa
     * 
     * @throws Exception
     *             例外が発生した場合
     */
    @Test
    public void メッセージが正しく生成されていること() throws Exception {
        FileNotFoundRuntimeException e = new FileNotFoundRuntimeException(
                new File("/notfound"), new FileNotFoundException());
        String result = e.getMessage();
        assertEquals("[ECDG0002]ファイルがありません。(notfound)", result);

    }

}
