/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.mysql;

import java.util.Collections;
import java.util.List;
import org.jiemamy.dialect.DefaultTokenResolver;
import org.jiemamy.dialect.mysql.internal.MySqlKeywords;
import org.jiemamy.dialect.mysql.parameter.MySqlParameterKeys;
import org.jiemamy.model.constraint.JmDeferrability;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.sql.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlTokenResolver
extends DefaultTokenResolver {
    public List<Token> resolve(Object value) {
        if (value instanceof JmDeferrability.InitiallyCheckTime) {
            return Collections.emptyList();
        }
        return super.resolve(value);
    }

    protected List<Token> resolveType(DataType type) {
        Boolean serial;
        List resolved = super.resolveType(type);
        Boolean unsigned = (Boolean)type.getParam(MySqlParameterKeys.UNSIGNED);
        if (unsigned != null && unsigned.booleanValue()) {
            resolved.add(0, MySqlKeywords.UNSIGNED);
        }
        if ((serial = (Boolean)type.getParam(TypeParameterKey.SERIAL)) != null && serial.booleanValue()) {
            resolved.add(MySqlKeywords.AUTO_INCREMENT);
        }
        return resolved;
    }
}

