/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.sql;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.model.sql.Separator;
import org.jiemamy.model.sql.SqlFormatter;
import org.jiemamy.model.sql.SqlStatement;
import org.jiemamy.model.sql.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSqlFormatter
implements SqlFormatter {
    public static final String WHITESPACE = " ";

    public static boolean isSeparator(Token token) {
        if (token == null) {
            return true;
        }
        return token instanceof Separator;
    }

    public String format(List<Token> tokens) {
        Validate.notNull(tokens);
        StringBuilder sb = new StringBuilder();
        Token lastToken = null;
        for (Token token : tokens) {
            if (!DefaultSqlFormatter.isSeparator(lastToken) && !DefaultSqlFormatter.isSeparator(token) || Separator.COMMA.equals(lastToken)) {
                sb.append(WHITESPACE);
            }
            sb.append(token);
            lastToken = token;
        }
        return sb.toString();
    }

    public String format(SqlStatement stmt) {
        Validate.notNull((Object)stmt);
        return this.format(stmt.toTokens());
    }
}

