/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.dataset.SimpleJmRecord;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.script.ScriptString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSetUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToCsv(JmDataSet dataSet, JmTable table, OutputStream out) throws IOException {
        Validate.notNull((Object)dataSet);
        Validate.notNull((Object)table);
        Validate.notNull((Object)out);
        List<JmRecord> records = dataSet.getRecords().get(table.toReference());
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new OutputStreamWriter(out));
            List<JmColumn> columns = table.getColumns();
            String[] line = new String[columns.size()];
            int i = 0;
            for (JmColumn column : columns) {
                line[i++] = column.getName();
            }
            writer.writeNext(line);
            for (JmRecord record : records) {
                line = new String[columns.size()];
                for (JmColumn column : columns) {
                    int index = columns.indexOf(column);
                    line[index] = record.getValues().get(column.toReference()).getScript();
                }
                writer.writeNext(line);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromCsv(JmDataSet dataSet, JmTable table, InputStream in) throws IOException {
        Validate.notNull((Object)dataSet);
        Validate.notNull((Object)table);
        Validate.notNull((Object)in);
        List<JmRecord> records = dataSet.getRecords().get(table.toReference());
        records.clear();
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new InputStreamReader(in));
            String[] line = reader.readNext();
            ArrayList columns = Lists.newArrayList();
            for (String columnName : line) {
                JmColumn column = table.getColumn(columnName);
                columns.add(column);
            }
            while ((line = reader.readNext()) != null) {
                HashMap values = Maps.newHashMap();
                for (int i = 0; i < line.length; ++i) {
                    values.put(((JmColumn)columns.get(i)).toReference(), new ScriptString(line[i]));
                }
                records.add(new SimpleJmRecord(values));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void setRecord(JmDataSet dataSet, JmTable table, List<JmRecord> records) {
        Validate.notNull((Object)dataSet);
        Validate.notNull((Object)table);
        Validate.notNull(records);
        dataSet.getRecords().put(table.toReference(), records);
    }

    private DataSetUtil() {
    }
}

