/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.column.SimpleJmColumn;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmColumnStaxHandler
extends StaxHandler<SimpleJmColumn> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmColumnStaxHandler.class);

    public SimpleJmColumnStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleJmColumn handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.COLUMN));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmColumn column = new SimpleJmColumn(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                ParameterMap params;
                JiemamyCursor parameterCursor;
                block14: {
                    childCursor.advance();
                    if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                        if (childCursor.isQName(CoreQName.NAME)) {
                            column.setName(childCursor.collectDescendantText(false));
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                            column.setLogicalName(childCursor.collectDescendantText(false));
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                            column.setDescription(childCursor.collectDescendantText(false));
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.DEFAULT_VALUE)) {
                            column.setDefaultValue(childCursor.collectDescendantText(false));
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.DATA_TYPE)) {
                            DataType type = (DataType)this.getDirector().direct(dctx);
                            if (type != null) {
                                column.setDataType(type);
                                continue;
                            }
                            logger.warn("null type");
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.PARAMETERS)) {
                            parameterCursor = childCursor.childElementCursor();
                            params = column.breachEncapsulationOfParams();
                            break block14;
                        } else {
                            logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                            continue;
                        }
                    }
                    if (childCursor.getCurrEvent() == null) continue;
                    logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                    continue;
                }
                while (parameterCursor.getNext() != null) {
                    if (!parameterCursor.isQName(CoreQName.PARAMETER)) {
                        logger.warn("unexpected: " + parameterCursor.getQName());
                        continue;
                    }
                    params.put(parameterCursor.getAttrValue(CoreQName.PARAMETER_KEY), parameterCursor.collectDescendantText(false));
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return column;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmColumn model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.COLUMN);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            sctx.push(element);
            DataType dataType = model.getDataType();
            if (dataType != null) {
                this.getDirector().direct(dataType, sctx);
            }
            element.addElementAndCharacters((JiemamyQName)CoreQName.DEFAULT_VALUE, model.getDefaultValue());
            ParameterMap params = model.getParams();
            if (params.size() > 0) {
                JiemamyOutputElement paramesElement = element.addElement(CoreQName.PARAMETERS);
                ArrayList paramList = Lists.newArrayList((Iterable)params);
                Collections.sort(paramList, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                        return e1.getKey().compareTo(e2.getKey());
                    }
                });
                for (Map.Entry entry : paramList) {
                    JiemamyOutputElement paramElement = paramesElement.addElement(CoreQName.PARAMETER);
                    paramElement.addAttribute((JiemamyQName)CoreQName.PARAMETER_KEY, (String)entry.getKey());
                    paramElement.addCharacters((String)entry.getValue());
                }
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

