/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.extension.jdbc.PropertyType;

public class RelationRowCreationResource {
    protected ResultSet resultSet;
    protected Object row;
    protected RelationPropertyType relationPropertyType;
    protected Set columnNames;
    protected Map relKeyValues;
    protected Map relationPropertyCache;
    protected String baseSuffix;
    protected String relationNoSuffix;
    protected int limitRelationNestLevel;
    protected int currentRelationNestLevel;
    protected PropertyType currentPropertyType;
    protected int validValueCount;
    protected boolean createDeadLink;
    protected Stack relationPropertyTypeBackup;
    protected Stack baseSuffixBackup;
    protected Stack relationSuffixBackup;

    public boolean hasRowInstance() {
        return this.row != null;
    }

    public void clearRowInstance() {
        this.row = null;
    }

    public BeanMetaData getRelationBeanMetaData() {
        return this.relationPropertyType.getBeanMetaData();
    }

    public boolean hasNextRelationProperty() {
        return this.getRelationBeanMetaData().getRelationPropertyTypeSize() > 0;
    }

    public void backupRelationPropertyType() {
        this.getOrCreateRelationPropertyTypeBackup().push(this.getRelationPropertyType());
    }

    public void restoreRelationPropertyType() {
        this.setRelationPropertyType((RelationPropertyType)this.getOrCreateRelationPropertyTypeBackup().pop());
    }

    protected Stack getOrCreateRelationPropertyTypeBackup() {
        if (this.relationPropertyTypeBackup == null) {
            this.relationPropertyTypeBackup = new Stack();
        }
        return this.relationPropertyTypeBackup;
    }

    public boolean containsColumnName(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public boolean existsRelKeyValues() {
        return this.relKeyValues != null;
    }

    public boolean containsRelKeyValue(String key) {
        return this.relKeyValues.containsKey(key);
    }

    public boolean containsRelKeyValueIfExists(String key) {
        return this.existsRelKeyValues() && this.relKeyValues.containsKey(key);
    }

    public Object extractRelKeyValue(String key) {
        return this.relKeyValues.get(key);
    }

    public void initializePropertyCacheElement() {
        this.relationPropertyCache.put(this.relationNoSuffix, new HashMap());
    }

    public boolean hasPropertyCacheElement() {
        Map propertyCacheElement = this.extractPropertyCacheElement();
        return propertyCacheElement != null && !propertyCacheElement.isEmpty();
    }

    public Map extractPropertyCacheElement() {
        return (Map)this.relationPropertyCache.get(this.relationNoSuffix);
    }

    public void savePropertyCacheElement() {
        String columnName;
        Map propertyCacheElement;
        if (!this.hasPropertyCacheElement()) {
            this.initializePropertyCacheElement();
        }
        if ((propertyCacheElement = this.extractPropertyCacheElement()).containsKey(columnName = this.buildRelationColumnName())) {
            return;
        }
        propertyCacheElement.put(columnName, this.currentPropertyType);
    }

    public String buildRelationColumnName() {
        return this.currentPropertyType.getColumnName() + this.relationNoSuffix;
    }

    public void addRelationNoSuffix(String additionalRelationNoSuffix) {
        this.relationNoSuffix = this.relationNoSuffix + additionalRelationNoSuffix;
    }

    public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
        this.backupBaseSuffix();
        this.backupRelationNoSuffix();
        this.baseSuffix = baseSuffix;
        this.addRelationNoSuffix(additionalRelationNoSuffix);
    }

    public void restoreSuffix() {
        this.restoreBaseSuffix();
        this.restoreRelationNoSuffix();
    }

    protected void backupBaseSuffix() {
        this.getOrCreateBaseSuffixBackup().push(this.getBaseSuffix());
    }

    protected void restoreBaseSuffix() {
        this.setBaseSuffix((String)this.getOrCreateBaseSuffixBackup().pop());
    }

    protected Stack getOrCreateBaseSuffixBackup() {
        if (this.baseSuffixBackup == null) {
            this.baseSuffixBackup = new Stack();
        }
        return this.baseSuffixBackup;
    }

    protected void backupRelationNoSuffix() {
        this.getOrCreateRelationNoSuffixBackup().push(this.getRelationNoSuffix());
    }

    protected void restoreRelationNoSuffix() {
        this.setRelationNoSuffix((String)this.getOrCreateRelationNoSuffixBackup().pop());
    }

    protected Stack getOrCreateRelationNoSuffixBackup() {
        if (this.relationSuffixBackup == null) {
            this.relationSuffixBackup = new Stack();
        }
        return this.relationSuffixBackup;
    }

    public boolean hasNextRelationLevel() {
        return this.currentRelationNestLevel < this.limitRelationNestLevel;
    }

    public void incrementCurrentRelationNestLevel() {
        ++this.currentRelationNestLevel;
    }

    public void decrementCurrentRelationNestLevel() {
        --this.currentRelationNestLevel;
    }

    public void incrementValidValueCount() {
        ++this.validValueCount;
    }

    public void clearValidValueCount() {
        this.validValueCount = 0;
    }

    public boolean hasValidValueCount() {
        return this.validValueCount > 0;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Set getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(Set columnNames) {
        this.columnNames = columnNames;
    }

    public Map getRelKeyValues() {
        return this.relKeyValues;
    }

    public void setRelKeyValues(Map relKeyValues) {
        this.relKeyValues = relKeyValues;
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public RelationPropertyType getRelationPropertyType() {
        return this.relationPropertyType;
    }

    public void setRelationPropertyType(RelationPropertyType rpt) {
        this.relationPropertyType = rpt;
    }

    public Map getRelationPropertyCache() {
        return this.relationPropertyCache;
    }

    public void setRelationPropertyCache(Map relationPropertyCache) {
        this.relationPropertyCache = relationPropertyCache;
    }

    public String getBaseSuffix() {
        return this.baseSuffix;
    }

    public void setBaseSuffix(String baseSuffix) {
        this.baseSuffix = baseSuffix;
    }

    public String getRelationNoSuffix() {
        return this.relationNoSuffix;
    }

    public void setRelationNoSuffix(String relationNoSuffix) {
        this.relationNoSuffix = relationNoSuffix;
    }

    public int getLimitRelationNestLevel() {
        return this.limitRelationNestLevel;
    }

    public void setLimitRelationNestLevel(int limitRelationNestLevel) {
        this.limitRelationNestLevel = limitRelationNestLevel;
    }

    public int getCurrentRelationNestLevel() {
        return this.currentRelationNestLevel;
    }

    public void setCurrentRelationNestLevel(int currentRelationNestLevel) {
        this.currentRelationNestLevel = currentRelationNestLevel;
    }

    public PropertyType getCurrentPropertyType() {
        return this.currentPropertyType;
    }

    public void setCurrentPropertyType(PropertyType propertyType) {
        this.currentPropertyType = propertyType;
    }

    public boolean isCreateDeadLink() {
        return this.createDeadLink;
    }

    public void setCreateDeadLink(boolean createDeadLink) {
        this.createDeadLink = createDeadLink;
    }
}

