/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.ArrayList;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.Dbms;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.AbstractPropertyTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;

public class FastPropertyTypeFactory
extends AbstractPropertyTypeFactory {
    private DaoNamingConvention daoNamingConvention;

    public FastPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming) {
        super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming);
    }

    public FastPropertyTypeFactory(Class beanClass, BeanAnnotationReader beanAnnotationReader, ValueTypeFactory valueTypeFactory, ColumnNaming columnNaming, DaoNamingConvention daoNamingConvention, Dbms dbms) {
        super(beanClass, beanAnnotationReader, valueTypeFactory, columnNaming, dbms);
        this.daoNamingConvention = daoNamingConvention;
    }

    public PropertyType[] createBeanPropertyTypes(String tableName) {
        ArrayList<PropertyType> list = new ArrayList<PropertyType>();
        BeanDesc beanDesc = this.getBeanDesc();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (this.isRelation(pd)) continue;
            PropertyType pt = this.createPropertyType(pd);
            pt.setPrimaryKey(this.isPrimaryKey(pd));
            pt.setPersistent(this.isPersistent(pt));
            list.add(pt);
        }
        return list.toArray(new PropertyType[list.size()]);
    }

    protected boolean isPersistent(PropertyType propertyType) {
        DaoNamingConvention convention = this.getDaoNamingConvention();
        String propertyName = propertyType.getPropertyName();
        if (propertyName.equals(convention.getModifiedPropertyNamesPropertyName())) {
            return false;
        }
        return super.isPersistent(propertyType);
    }

    public DaoNamingConvention getDaoNamingConvention() {
        if (this.daoNamingConvention == null) {
            throw new EmptyRuntimeException("daoNamingConvention");
        }
        return this.daoNamingConvention;
    }
}

