/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.util.CaseInsensitiveMap;

public class DtoMetaDataImpl
implements DtoMetaData {
    private Class beanClass;
    private CaseInsensitiveMap propertyTypes = new CaseInsensitiveMap();
    protected BeanAnnotationReader beanAnnotationReader;
    protected PropertyTypeFactory propertyTypeFactory;

    public void initialize() {
        this.setupPropertyType();
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public int getPropertyTypeSize() {
        return this.propertyTypes.size();
    }

    public PropertyType getPropertyType(int index) {
        return (PropertyType)this.propertyTypes.get(index);
    }

    public PropertyType getPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypes.get((Object)propertyName);
        if (propertyType == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return propertyType;
    }

    public boolean hasPropertyType(String propertyName) {
        return this.propertyTypes.get((Object)propertyName) != null;
    }

    protected void setupPropertyType() {
        PropertyType[] propertyTypes = this.propertyTypeFactory.createDtoPropertyTypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            this.addPropertyType(pt);
        }
    }

    protected void addPropertyType(PropertyType propertyType) {
        this.propertyTypes.put((Object)propertyType.getPropertyName(), (Object)propertyType);
    }

    public void setBeanAnnotationReader(BeanAnnotationReader beanAnnotationReader) {
        this.beanAnnotationReader = beanAnnotationReader;
    }

    public void setPropertyTypeFactory(PropertyTypeFactory propertyTypeFactory) {
        this.propertyTypeFactory = propertyTypeFactory;
    }
}

