/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.ProcedureMetaDataFactory;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class DaoMetaDataFactoryImpl
implements DaoMetaDataFactory,
Disposable {
    public static final String dataSource_BINDING = "bindingType=must";
    public static final String statementFactory_BINDING = "bindingType=must";
    public static final String resultSetFactory_BINDING = "bindingType=must";
    public static final String annotationReaderFactory_BINDING = "bindingType=must";
    public static final String valueTypeFactory_BINDING = "bindingType=must";
    public static final String beanMetaDataFactory_BINDING = "bindingType=must";
    public static final String daoNamingConvention_BINDING = "bindingType=must";
    public static final String resultSetHandlerFactory_BINDING = "bindingType=must";
    public static final String dtoMetaDataFactory_BINDING = "bindingType=must";
    public static final String procedureMetaDataFactory_BINDING = "bindingType=must";
    public static final String pagingSQLRewriter_BINDING = "bindingType=may";
    protected DataSource dataSource;
    protected StatementFactory statementFactory;
    protected ResultSetFactory resultSetFactory;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected ValueTypeFactory valueTypeFactory;
    protected BeanMetaDataFactory beanMetaDataFactory;
    protected DaoNamingConvention daoNamingConvention;
    protected ResultSetHandlerFactory resultSetHandlerFactory;
    protected DtoMetaDataFactory dtoMetaDataFactory;
    protected ProcedureMetaDataFactory procedureMetaDataFactory;
    protected PagingSqlRewriter pagingSqlRewriter;
    protected Map daoMetaDataCache = new HashMap();
    protected boolean initialized;
    protected boolean useDaoClassForLog;
    protected String sqlFileEncoding;

    public DaoMetaDataFactoryImpl() {
    }

    public DaoMetaDataFactoryImpl(DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory, AnnotationReaderFactory annotationReaderFactory) {
        this.dataSource = dataSource;
        this.statementFactory = statementFactory;
        this.resultSetFactory = resultSetFactory;
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setSqlFileEncoding(String encoding) {
        this.sqlFileEncoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaoMetaData getDaoMetaData(Class daoClass) {
        DaoMetaData dmd;
        if (!this.initialized) {
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
        String key = daoClass.getName();
        Map map = this.daoMetaDataCache;
        synchronized (map) {
            dmd = (DaoMetaData)this.daoMetaDataCache.get(key);
        }
        if (dmd != null) {
            return dmd;
        }
        DaoMetaData dmdi = this.createDaoMetaData(daoClass);
        Map map2 = this.daoMetaDataCache;
        synchronized (map2) {
            dmd = (DaoMetaData)this.daoMetaDataCache.get(daoClass);
            if (dmd != null) {
                return dmd;
            }
            this.daoMetaDataCache.put(key, dmdi);
        }
        return dmdi;
    }

    protected DaoMetaData createDaoMetaData(Class daoClass) {
        BeanDesc daoBeanDesc = BeanDescFactory.getBeanDesc((Class)daoClass);
        DaoAnnotationReader daoAnnotationReader = this.annotationReaderFactory.createDaoAnnotationReader(daoBeanDesc);
        DaoMetaDataImpl daoMetaData = this.createDaoMetaDataImpl();
        daoMetaData.setDaoClass(daoClass);
        daoMetaData.setDataSource(this.dataSource);
        daoMetaData.setStatementFactory(this.statementFactory);
        daoMetaData.setResultSetFactory(this.resultSetFactory);
        daoMetaData.setValueTypeFactory(this.valueTypeFactory);
        daoMetaData.setBeanMetaDataFactory(this.getBeanMetaDataFactory());
        daoMetaData.setDaoNamingConvention(this.getDaoNamingConvention());
        daoMetaData.setUseDaoClassForLog(this.useDaoClassForLog);
        daoMetaData.setDaoAnnotationReader(daoAnnotationReader);
        daoMetaData.setProcedureMetaDataFactory(this.procedureMetaDataFactory);
        daoMetaData.setDtoMetaDataFactory(this.dtoMetaDataFactory);
        daoMetaData.setResultSetHandlerFactory(this.resultSetHandlerFactory);
        if (this.sqlFileEncoding != null) {
            daoMetaData.setSqlFileEncoding(this.sqlFileEncoding);
        }
        if (this.pagingSqlRewriter != null) {
            daoMetaData.setPagingSQLRewriter(this.pagingSqlRewriter);
        }
        daoMetaData.initialize();
        return daoMetaData;
    }

    protected DaoMetaDataImpl createDaoMetaDataImpl() {
        return new DaoMetaDataImpl();
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected BeanMetaDataFactory getBeanMetaDataFactory() {
        return this.beanMetaDataFactory;
    }

    public void setBeanMetaDataFactory(BeanMetaDataFactory beanMetaDataFactory) {
        this.beanMetaDataFactory = beanMetaDataFactory;
    }

    public synchronized void dispose() {
        this.daoMetaDataCache.clear();
        this.initialized = false;
    }

    public DaoNamingConvention getDaoNamingConvention() {
        return this.daoNamingConvention;
    }

    public void setDaoNamingConvention(DaoNamingConvention daoNamingConvention) {
        this.daoNamingConvention = daoNamingConvention;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    public void setUseDaoClassForLog(boolean userDaoClassForLog) {
        this.useDaoClassForLog = userDaoClassForLog;
    }

    public void setResultSetHandlerFactory(ResultSetHandlerFactory resultSetHandlerFactory) {
        this.resultSetHandlerFactory = resultSetHandlerFactory;
    }

    public void setDtoMetaDataFactory(DtoMetaDataFactory dtoMetaDataFactory) {
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    public void setProcedureMetaDataFactory(ProcedureMetaDataFactory procedureMetaDataFactory) {
        this.procedureMetaDataFactory = procedureMetaDataFactory;
    }

    public void setPagingSQLRewriter(PagingSqlRewriter pagingSqlRewriter) {
        this.pagingSqlRewriter = pagingSqlRewriter;
    }
}

