/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import javax.sql.DataSource;
import org.seasar.dao.InjectDaoClassSupport;
import org.seasar.dao.ProcedureMetaData;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.handler.ArgumentDtoProcedureHandler;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;

public class ArgumentDtoProcedureCommand
implements SqlCommand,
InjectDaoClassSupport {
    protected DataSource dataSource;
    protected ResultSetHandler resultSetHandler;
    protected StatementFactory statementFactory;
    protected ResultSetFactory resultSetFactory;
    protected ProcedureMetaData procedureMetaData;
    protected Class daoClass;

    public ArgumentDtoProcedureCommand(DataSource dataSource, ResultSetHandler resultSetHandler, StatementFactory statementFactory, ResultSetFactory resultSetFactory, ProcedureMetaData procedureMetaData) {
        this.dataSource = dataSource;
        this.resultSetHandler = resultSetHandler;
        this.statementFactory = statementFactory;
        this.resultSetFactory = resultSetFactory;
        this.procedureMetaData = procedureMetaData;
    }

    public Object execute(Object[] args) {
        ArgumentDtoProcedureHandler handler = new ArgumentDtoProcedureHandler(this.dataSource, this.createSql(this.procedureMetaData), this.resultSetHandler, this.statementFactory, this.resultSetFactory, this.procedureMetaData);
        if (this.daoClass != null) {
            handler.setLoggerClass(this.daoClass);
        }
        handler.setFetchSize(-1);
        return handler.execute(args);
    }

    public void setDaoClass(Class clazz) {
        this.daoClass = clazz;
    }

    protected String createSql(ProcedureMetaData procedureMetaData) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int size = procedureMetaData.getParameterTypeSize();
        if (procedureMetaData.hasReturnParameterType()) {
            buf.append("? = ");
            --size;
        }
        buf.append("call ");
        buf.append(procedureMetaData.getProcedureName());
        buf.append(" (");
        for (int i = 0; i < size; ++i) {
            buf.append("?, ");
        }
        if (size > 0) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")}");
        return buf.toString();
    }
}

