/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.reflect.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodUtil {
    private static final int BUFF_SIZE = 100;
    private static final Method IS_BRIDGE_METHOD = MethodUtil.getIsBridgeMethod();
    private static final Method IS_SYNTHETIC_METHOD = MethodUtil.getIsSyntheticMethod();
    private static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("Collection");
    private static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("Collection");
    private static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("List");
    private static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("List");
    private static final Method GET_ELEMENT_TYPE_OF_SET_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("Set");
    private static final Method GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("Set");

    public static Class<?> getElementTypeOfCollectionFromParameterType(Method method, int position) throws IllegalAccessException, InvocationTargetException {
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_PARAMETER_METHOD, null, new Object[]{method, position});
    }

    public static Class<?> getElementTypeOfCollectionFromReturnType(Method method) throws IllegalAccessException, InvocationTargetException {
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    public static Class<?> getElementTypeOfListFromParameterType(Method method, int position) throws IllegalAccessException, InvocationTargetException {
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_PARAMETER_METHOD, null, new Object[]{method, position});
    }

    public static Class<?> getElementTypeOfListFromReturnType(Method method) throws IllegalAccessException, InvocationTargetException {
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    public static Class<?> getElementTypeOfSetFromParameterType(Method method, int position) throws IllegalAccessException, InvocationTargetException {
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_PARAMETER_METHOD, null, new Object[]{method, position});
    }

    public static Class<?> getElementTypeOfSetFromReturnType(Method method) throws IllegalAccessException, InvocationTargetException {
        if (GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    public static String getSignature(String methodName, Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(methodName);
        sb.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getName());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getSignature(String methodName, Object[] methodArgs) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(methodName);
        sb.append("(");
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (methodArgs[i] != null) {
                    sb.append(methodArgs[i].getClass().getName());
                    continue;
                }
                sb.append("null");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static Object invoke(Method method, Object target, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Validate.notNull((Object)method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw ex;
        }
    }

    public static boolean isBridgeMethod(Method method) throws IllegalAccessException, InvocationTargetException {
        if (IS_BRIDGE_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_BRIDGE_METHOD, method, null);
    }

    public static boolean isEqualsMethod(Method method) {
        return method != null && method.getName().equals("equals") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isSyntheticMethod(Method method) throws IllegalAccessException, InvocationTargetException {
        if (IS_SYNTHETIC_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_SYNTHETIC_METHOD, method, null);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getReturnType() == String.class && method.getParameterTypes().length == 0;
    }

    protected static Method getElementTypeFromParameterMethod(String type) {
        try {
            Class<ReflectionUtil> reflectionUtilClass = ReflectionUtil.class;
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromParameterType", Method.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static Method getElementTypeFromReturnMethod(String type) {
        try {
            Class<ReflectionUtil> reflectionUtilClass = ReflectionUtil.class;
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromReturnType", Method.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getIsBridgeMethod() {
        try {
            return Method.class.getMethod("isBridge", new Class[]{null});
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getIsSyntheticMethod() {
        try {
            return Method.class.getMethod("isSynthetic", new Class[]{null});
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private MethodUtil() {
    }
}

