/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.collection;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import org.jiemamy.utils.collection.ListSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListSet<E>
extends AbstractList<E>
implements ListSet<E> {
    private final ArrayList<E> list = Lists.newArrayList();

    @Override
    public boolean add(E element) {
        boolean result = !this.list.contains(element);
        super.add(element);
        return result;
    }

    @Override
    public void add(int index, E element) {
        if (!this.list.contains(element)) {
            this.list.add(index, element);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayListSet other = (ArrayListSet)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        E prev = this.list.get(index);
        this.list.remove(index);
        if (!this.list.contains(element)) {
            this.list.add(index, element);
            return prev;
        }
        this.list.add(index, prev);
        throw new IllegalArgumentException();
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

