/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityRef<T extends Entity>
implements EntityRef<T> {
    final UUID referentId;

    public static <T extends Entity> DefaultEntityRef<T> of(UUID referentId) {
        return new DefaultEntityRef<T>(referentId);
    }

    public DefaultEntityRef(T referent) {
        Validate.notNull(referent);
        Validate.notNull((Object)referent.getId());
        this.referentId = referent.getId();
    }

    public DefaultEntityRef(UUID referentId) {
        Validate.notNull((Object)referentId);
        this.referentId = referentId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRef)) {
            return false;
        }
        return this.referentId.equals(((EntityRef)obj).getReferentId());
    }

    @Override
    public UUID getReferentId() {
        return this.referentId;
    }

    public int hashCode() {
        return this.referentId.hashCode();
    }

    @Override
    public boolean isReferenceOf(Entity target) {
        return this.referentId.equals(target.getId());
    }

    public String toString() {
        return "Ref(" + this.referentId.toString().substring(0, 8) + ")";
    }
}

