/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.lib.impl;

import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Condition;
import org.seasar.framework.util.StringUtil;

/**
 * @author azusa
 * 
 */
public class ColumnImpl implements Column {

    /**
     * コンストラクタ
     * 
     * @param alias
     *            別名
     * @param name
     *            カラム名
     */
    public ColumnImpl(String alias, String name, Class<? extends Condition> clazz) {
        this.alias = alias;
        this.name = name;
        this.clazz = clazz;
    }

    public String getAlias() {
        return alias;
    }

    public String getName() {
        return name;
    }

    private String alias;

    private String name;

    private Class<? extends Condition> clazz;

    @Override
    public String toString() {
        return (StringUtil.isEmpty(alias) ? "" : alias + ".") + name;
    }

    public Class<? extends Condition> getCodnitionClass() {
        return this.clazz;
    }

}
