/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.lib.impl;

import java.util.List;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.ConditionElement;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Operator;
import org.seasar.codegen.lib.impl.BindValueImpl;
import org.seasar.codegen.lib.internal.impl.ValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionElementImpl<T>
implements ConditionElement<T> {
    protected ConditionResult conditionResult;
    protected Column column;
    private final Object[] EMPTY = new Object[0];

    public ConditionElementImpl(ConditionResult conditionResult, Column column) {
        this.conditionResult = conditionResult;
        this.column = column;
    }

    @Override
    public void addOrderAsc() {
        this.conditionResult.addOrder(this.column, true);
    }

    @Override
    public void addOrderDesc() {
        this.conditionResult.addOrder(this.column, false);
    }

    @Override
    public void equal(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.EQUAL, new Object[]{value}));
    }

    @Override
    public void in(T ... values) {
        ValueValidator.validate(values, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.IN, values));
    }

    @Override
    public void in(List<T> values) {
        ValueValidator.validate(values, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.IN, values.toArray()));
    }

    @Override
    public void isNotNull() {
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.NOT_NULL, this.EMPTY));
    }

    @Override
    public void isNull() {
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.NULL, this.EMPTY));
    }

    @Override
    public void less(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.LESS, new Object[]{value}));
    }

    @Override
    public void lessThan(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.LESSTHAN, new Object[]{value}));
    }

    @Override
    public void more(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.MORE, new Object[]{value}));
    }

    @Override
    public void moreThan(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.MORETHAN, new Object[]{value}));
    }

    @Override
    public void not(T value) {
        ValueValidator.validate(value, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.NOT, new Object[]{value}));
    }

    @Override
    public void notIn(T ... values) {
        ValueValidator.validate(values, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.NOTIN, values));
    }

    @Override
    public void notIn(List<T> values) {
        ValueValidator.validate(values, this.column);
        this.conditionResult.addBindValue(new BindValueImpl(this.column, Operator.NOTIN, values.toArray()));
    }
}

