/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.lib.internal.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.annotation.SqlFileEncoding;
import org.seasar.codegen.lib.internal.impl.FindSqlCommand;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.annotation.tiger.util.AnnotationUtil;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class CodeGenDaoMetaDataImpl
extends DaoMetaDataImpl
implements Disposable {
    public static final String RELATION_METHOD_SUFFIX = "WithRelation";
    protected Map beanMetaDataCache = new HashMap();
    protected String encoding;

    public CodeGenDaoMetaDataImpl() {
        DisposableUtil.add((Disposable)this);
    }

    protected void setupMethod(Method method) {
        Class<?>[] paramerClasses = method.getParameterTypes();
        if (method.getName().endsWith(RELATION_METHOD_SUFFIX)) {
            this.setupFindMethod(method);
            return;
        }
        for (Class<?> clazz : paramerClasses) {
            if (!Condition.class.isAssignableFrom(clazz)) continue;
            this.setupFindMethod(method);
            return;
        }
        super.setupMethod(method);
    }

    protected void setupFindMethod(Method method) {
        this.sqlCommands.put(method.getName(), this.getFindSqlCommand(method));
    }

    protected SqlCommand getFindSqlCommand(Method method) {
        BeanMetaData beanMetaData = this.getBeanMetaData(this.daoAnnotationReader.getBeanClass(method));
        ResultSetHandler resultSetHandler = this.createResultSetHandlerFromReturnType(method, beanMetaData);
        String baseSql = this.createBaseSQL(method, beanMetaData);
        FindSqlCommand command = new FindSqlCommand(this.dataSource, this.statementFactory, resultSetHandler, this.resultSetFactory, this.pagingSqlRewriter, baseSql);
        command.setArgNames(this.daoAnnotationReader.getArgNames(method));
        command.setArgTypes(method.getParameterTypes());
        return command;
    }

    protected String createBaseSQL(Method method, BeanMetaData beanMetaData) {
        String query = this.daoAnnotationReader.getQuery(method);
        String baseSql = query == null ? this.dbms.getAutoSelectSql(beanMetaData) : (CodeGenDaoMetaDataImpl.startsWithOrderBy((String)query) ? this.dbms.getAutoSelectSql(beanMetaData) + " " + query : this.dbms.getAutoSelectSql(beanMetaData) + " WHERE " + query);
        return baseSql;
    }

    protected ResultSetHandler createResultSetHandlerFromReturnType(Method method, BeanMetaData beanMetaData) {
        Class<?> retType = method.getReturnType();
        if (ClassUtil.isAssignableFrom(List.class, retType)) {
            return new BeanListMetaDataResultSetHandler(beanMetaData, (RowCreator)new RowCreatorImpl(), (RelationRowCreator)new RelationRowCreatorImpl());
        }
        if (retType.isArray()) {
            return new BeanArrayMetaDataResultSetHandler(beanMetaData, (RowCreator)new RowCreatorImpl(), (RelationRowCreator)new RelationRowCreatorImpl());
        }
        return new BeanMetaDataResultSetHandler.RestrictBeanMetaDataResultSetHandler(beanMetaData, (RowCreator)new RowCreatorImpl(), (RelationRowCreator)new RelationRowCreatorImpl());
    }

    protected BeanMetaData getBeanMetaData(Class beanClass) {
        BeanMetaData ret = (BeanMetaData)this.beanMetaDataCache.get(beanClass);
        if (ret == null) {
            BeanMetaData newBeanMetaData = this.beanMetaDataFactory.createBeanMetaData(beanClass);
            this.beanMetaDataCache.put(beanClass, newBeanMetaData);
            return newBeanMetaData;
        }
        return ret;
    }

    public void dispose() {
        this.beanMetaDataCache.clear();
    }

    protected void setupMethodBySqlFile(Class arg0, Method arg1) {
        super.setupMethodBySqlFile(arg0, arg1);
    }

    protected String getSqlFileEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        SqlFileEncoding encoding = (SqlFileEncoding)AnnotationUtil.getAnnotation((Class)this.daoClass, SqlFileEncoding.class);
        if (encoding != null) {
            this.encoding = encoding.value();
            return encoding != null ? encoding.value() : super.getSqlFileEncoding();
        }
        return super.getSqlFileEncoding();
    }
}

