/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.lib.internal.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.codegen.lib.BindValue;
import org.seasar.codegen.lib.Column;
import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.Order;
import org.seasar.codegen.lib.Query;
import org.seasar.codegen.lib.impl.BindValueImpl;
import org.seasar.dao.CommandContext;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindSqlCommand
extends SelectDynamicCommand {
    protected final PagingSqlRewriter sqlRewriter;
    protected final ResultSetHandler resultSetHandler;
    protected final ResultSetFactory resultSetFactory;
    protected final String baseSql;

    public FindSqlCommand(DataSource dataSource, StatementFactory statementFactory, ResultSetHandler resultSetHandler, ResultSetFactory resultSetFactory, PagingSqlRewriter pagingSqlRewriter, String baseSql) {
        super(dataSource, statementFactory, resultSetHandler, resultSetFactory, pagingSqlRewriter);
        this.sqlRewriter = pagingSqlRewriter;
        this.resultSetHandler = resultSetHandler;
        this.resultSetFactory = resultSetFactory;
        this.baseSql = baseSql;
    }

    public Object execute(Object[] args) {
        String sql = this.baseSql;
        Condition condition = null;
        ConditionResult conditionResult = null;
        Object[] bindVariables = null;
        Class[] bindVariableTypes = null;
        if (args.length != 0 && args[0] instanceof Condition) {
            condition = (Condition)args[0];
            conditionResult = condition.getConditionResult();
            sql = this.baseSql + this.createSql(conditionResult);
            this.setSql(sql);
            bindVariables = this.createVariables(conditionResult);
            bindVariableTypes = this.createVariablesTypes(bindVariables);
        } else {
            this.setSql(sql);
            CommandContext ctx = this.apply(args);
            bindVariables = ctx.getBindVariables();
            bindVariableTypes = ctx.getBindVariableTypes();
            sql = ctx.getSql();
        }
        String executingSql = this.sqlRewriter.rewrite(sql, bindVariables, bindVariableTypes);
        BasicSelectHandler selectHandler = new BasicSelectHandler(this.getDataSource(), executingSql, this.resultSetHandler, this.getStatementFactory(), this.resultSetFactory);
        this.injectDaoClass((BasicHandler)selectHandler);
        selectHandler.setFetchSize(-1);
        return selectHandler.execute(bindVariables, bindVariableTypes);
    }

    protected StringBuilder createSql(ConditionResult conditionResult) {
        StringBuilder sb = new StringBuilder();
        if (conditionResult.getBindValues().size() != 0 || !StringUtil.isEmpty((String)conditionResult.getQuery().getQuery())) {
            sb.append(" WHERE ");
        } else {
            sb.append(" ");
        }
        Iterator<BindValue> i = conditionResult.getBindValues().iterator();
        while (i.hasNext()) {
            BindValue bindValue = i.next();
            String alias = bindValue.getColumn().getAlias();
            String column = bindValue.getColumn().getName();
            if (!StringUtil.isEmpty((String)alias)) {
                sb.append(alias).append(".").append(column);
            } else {
                sb.append(column);
            }
            sb.append(" ");
            sb.append(bindValue.getOperator().getOperator());
            Object[] args = bindValue.getArgs();
            switch (bindValue.getOperator()) {
                case EQUAL: 
                case LESS: 
                case LESSTHAN: 
                case MORE: 
                case MORETHAN: 
                case LIKE: 
                case NOT: {
                    sb.append("?");
                    break;
                }
                case IN: 
                case NOTIN: {
                    sb.append("(");
                    for (int k = 0; k < args.length; ++k) {
                        if (k != 0) {
                            sb.append(",");
                        }
                        sb.append("?");
                    }
                    sb.append(")");
                }
                case NOT_NULL: 
                case NULL: {
                    break;
                }
            }
            if (!i.hasNext()) continue;
            sb.append(" AND ");
        }
        if (StringUtil.isNotEmpty((String)conditionResult.getQuery().getQuery()) && !conditionResult.getBindValues().isEmpty()) {
            sb.append(" AND ");
        }
        sb.append(conditionResult.getQuery().getQuery());
        this.addOrder(conditionResult, sb);
        return sb;
    }

    protected Object[] createVariables(ConditionResult conditionResult) {
        List<BindValue> list = conditionResult.getBindValues();
        ArrayList<BindValue> actualList = new ArrayList<BindValue>(list);
        Query query = conditionResult.getQuery();
        if (query.getArgs().length != 0) {
            actualList.add(new BindValueImpl(query.getArgs()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (BindValue bindValue : actualList) {
            Object[] args;
            for (Object object : args = bindValue.getArgs()) {
                result.add(object);
            }
        }
        return result.toArray();
    }

    protected Class<?>[] createVariablesTypes(Object[] bindVariables) {
        Class[] bindVariablesTypes = new Class[bindVariables.length];
        for (int i = 0; i < bindVariables.length; ++i) {
            bindVariablesTypes[i] = bindVariables[i].getClass();
        }
        return bindVariablesTypes;
    }

    private String addOrder(ConditionResult conditionResult, StringBuilder sb) {
        List<Order> orderList = conditionResult.getOrderList();
        Iterator<Order> i = orderList.iterator();
        if (i.hasNext()) {
            sb.append(" ");
            sb.append("ORDER BY ");
        }
        while (i.hasNext()) {
            Order order = i.next();
            Column column = order.getColumn();
            if (StringUtil.isEmpty((String)column.getAlias())) {
                sb.append(column.getName());
            } else {
                sb.append(column.getAlias());
                sb.append(".");
                sb.append(column.getName());
            }
            if (!order.isAsc()) {
                sb.append(" DESC ");
            }
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

