/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.seasar.aptina.commons.util.IOUtils;

class InMemoryJavaFileObject
extends SimpleJavaFileObject {
    byte[] content;
    ByteArrayOutputStream outputStream;
    final Charset charset;

    public InMemoryJavaFileObject(URI uri, JavaFileObject.Kind kind, Charset charset) {
        super(uri, kind);
        this.charset = charset;
    }

    public InMemoryJavaFileObject(URI uri, JavaFileObject.Kind kind, Charset charset, byte[] content) {
        super(uri, kind);
        this.charset = charset;
        this.content = content;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.content != null ? this.content : (this.outputStream != null ? this.outputStream.toByteArray() : new byte[]{}));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.content = null;
        this.outputStream = new ByteArrayOutputStream(1024);
        return this.outputStream;
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream(), this.charset);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return new String(IOUtils.readBytes(this.openInputStream()), this.charset == null ? Charset.defaultCharset() : this.charset);
    }
}

